/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final boolean hasPath;
    private final int maxParams;
    private String path;
    private Map<String, List<String>> params;
    private int nParams;

    public QueryStringDecoder(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(String string, boolean bl) {
        this(string, HttpConstants.DEFAULT_CHARSET, bl);
    }

    public QueryStringDecoder(String string, Charset charset) {
        this(string, charset, true);
    }

    public QueryStringDecoder(String string, Charset charset, boolean bl) {
        this(string, charset, bl, 1024);
    }

    public QueryStringDecoder(String string, Charset charset, boolean bl, int n2) {
        if (string == null) {
            throw new NullPointerException("getUri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxParams: " + n2 + " (expected: a positive integer)");
        }
        this.uri = string;
        this.charset = charset;
        this.maxParams = n2;
        this.hasPath = bl;
    }

    public QueryStringDecoder(URI uRI) {
        this(uRI, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(URI uRI, Charset charset) {
        this(uRI, charset, 1024);
    }

    public QueryStringDecoder(URI uRI, Charset charset, int n2) {
        if (uRI == null) {
            throw new NullPointerException("getUri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxParams: " + n2 + " (expected: a positive integer)");
        }
        String string = uRI.getRawPath();
        if (string != null) {
            this.hasPath = true;
        } else {
            string = "";
            this.hasPath = false;
        }
        this.uri = string + (uRI.getRawQuery() == null ? "" : "?" + uRI.getRawQuery());
        this.charset = charset;
        this.maxParams = n2;
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            int n2;
            this.path = !this.hasPath ? "" : QueryStringDecoder.decodeComponent((n2 = this.uri.indexOf(63)) < 0 ? this.uri : this.uri.substring(0, n2), this.charset);
        }
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            if (this.hasPath) {
                int n2 = this.uri.indexOf(63);
                if (n2 >= 0 && n2 < this.uri.length() - 1) {
                    QueryStringDecoder queryStringDecoder = this;
                    queryStringDecoder.decodeParams(queryStringDecoder.uri.substring(n2 + 1));
                } else {
                    this.params = Collections.emptyMap();
                }
            } else if (this.uri.isEmpty()) {
                this.params = Collections.emptyMap();
            } else {
                QueryStringDecoder queryStringDecoder = this;
                queryStringDecoder.decodeParams(queryStringDecoder.uri);
            }
        }
        return this.params;
    }

    private void decodeParams(String string) {
        int n2;
        this.params = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> linkedHashMap = this.params;
        this.nParams = 0;
        String string2 = null;
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '=' && string2 == null) {
                if (n3 != n2) {
                    string2 = QueryStringDecoder.decodeComponent(string.substring(n3, n2), this.charset);
                }
                n3 = n2 + 1;
                continue;
            }
            if (c2 != '&' && c2 != ';') continue;
            if (string2 == null && n3 != n2) {
                if (!this.addParam(linkedHashMap, QueryStringDecoder.decodeComponent(string.substring(n3, n2), this.charset), "")) {
                    return;
                }
            } else if (string2 != null) {
                if (!this.addParam(linkedHashMap, string2, QueryStringDecoder.decodeComponent(string.substring(n3, n2), this.charset))) {
                    return;
                }
                string2 = null;
            }
            n3 = n2 + 1;
        }
        if (n3 != n2) {
            if (string2 == null) {
                this.addParam(linkedHashMap, QueryStringDecoder.decodeComponent(string.substring(n3, n2), this.charset), "");
                return;
            }
            this.addParam(linkedHashMap, string2, QueryStringDecoder.decodeComponent(string.substring(n3, n2), this.charset));
            return;
        }
        if (string2 != null) {
            this.addParam(linkedHashMap, string2, "");
        }
    }

    private boolean addParam(Map<String, List<String>> map, String string, String string2) {
        if (this.nParams >= this.maxParams) {
            return false;
        }
        List<String> list = map.get(string);
        if (list == null) {
            list = new ArrayList<String>(1);
            map.put(string, list);
        }
        list.add(string2);
        ++this.nParams;
        return true;
    }

    public static String decodeComponent(String string) {
        return QueryStringDecoder.decodeComponent(string, HttpConstants.DEFAULT_CHARSET);
    }

    public static String decodeComponent(String string, Charset charset) {
        int n2;
        if (string == null) {
            return "";
        }
        int n3 = string.length();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = string.charAt(i2);
            if (n2 != 37 && n2 != 43) continue;
            n4 = 1;
            break;
        }
        if (n4 == 0) {
            return string;
        }
        byte[] byArray = new byte[n3];
        n2 = 0;
        block5: for (n4 = 0; n4 < n3; ++n4) {
            char c2 = string.charAt(n4);
            switch (c2) {
                case '+': {
                    byArray[n2++] = 32;
                    continue block5;
                }
                case '%': {
                    if (n4 == n3 - 1) {
                        throw new IllegalArgumentException("unterminated escape sequence at end of string: " + string);
                    }
                    if ((c2 = string.charAt(++n4)) == '%') {
                        byArray[n2++] = 37;
                        continue block5;
                    }
                    if (n4 == n3 - 1) {
                        throw new IllegalArgumentException("partial escape sequence at end of string: " + string);
                    }
                    c2 = QueryStringDecoder.decodeHexNibble(c2);
                    char c3 = QueryStringDecoder.decodeHexNibble(string.charAt(++n4));
                    if (c2 == '\uffff' || c3 == '\uffff') {
                        throw new IllegalArgumentException("invalid escape sequence `%" + string.charAt(n4 - 1) + string.charAt(n4) + "' at index " + (n4 - 2) + " of: " + string);
                    }
                    c2 = (char)((c2 << 4) + c3);
                }
                default: {
                    byArray[n2++] = (byte)c2;
                }
            }
        }
        return new String(byArray, 0, n2, charset);
    }

    private static char decodeHexNibble(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return (char)(c2 - 48);
        }
        if ('a' <= c2 && c2 <= 'f') {
            return (char)(c2 - 97 + 10);
        }
        if ('A' <= c2 && c2 <= 'F') {
            return (char)(c2 - 65 + 10);
        }
        return '\uffff';
    }
}

