/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.QueryStringEncoder$Param;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;

public class QueryStringEncoder {
    private final Charset charset;
    private final String uri;
    private final List<QueryStringEncoder$Param> params = new ArrayList<QueryStringEncoder$Param>();

    public QueryStringEncoder(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringEncoder(String string, Charset charset) {
        if (string == null) {
            throw new NullPointerException("getUri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.uri = string;
        this.charset = charset;
    }

    public void addParam(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.params.add(new QueryStringEncoder$Param(string, string2));
    }

    public URI toUri() {
        return new URI(this.toString());
    }

    public String toString() {
        if (this.params.isEmpty()) {
            return this.uri;
        }
        StringBuilder stringBuilder = new StringBuilder(this.uri).append('?');
        for (int i2 = 0; i2 < this.params.size(); ++i2) {
            QueryStringEncoder$Param queryStringEncoder$Param = this.params.get(i2);
            stringBuilder.append(QueryStringEncoder.encodeComponent(queryStringEncoder$Param.name, this.charset));
            if (queryStringEncoder$Param.value != null) {
                stringBuilder.append('=');
                stringBuilder.append(QueryStringEncoder.encodeComponent(queryStringEncoder$Param.value, this.charset));
            }
            if (i2 == this.params.size() - 1) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private static String encodeComponent(String string, Charset charset) {
        try {
            return URLEncoder.encode(string, charset.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }
}

