/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaderDateFormat;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.Cookie;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.DefaultCookie;
import java.text.ParsePosition;
import java.util.Date;

class ClientCookieDecoder$CookieBuilder {
    private final String header;
    private final DefaultCookie cookie;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private int expiresStart;
    private int expiresEnd;
    private boolean secure;
    private boolean httpOnly;

    public ClientCookieDecoder$CookieBuilder(DefaultCookie defaultCookie, String string) {
        this.cookie = defaultCookie;
        this.header = string;
    }

    private long mergeMaxAgeAndExpires() {
        if (this.maxAge != Long.MIN_VALUE) {
            return this.maxAge;
        }
        ClientCookieDecoder$CookieBuilder clientCookieDecoder$CookieBuilder = this;
        Object object = clientCookieDecoder$CookieBuilder.computeValue(clientCookieDecoder$CookieBuilder.expiresStart, this.expiresEnd);
        if (object != null && (object = HttpHeaderDateFormat.get().parse((String)object, new ParsePosition(0))) != null) {
            long l2 = ((Date)object).getTime() - System.currentTimeMillis();
            return l2 / 1000L + (long)(l2 % 1000L != 0L ? 1 : 0);
        }
        return Long.MIN_VALUE;
    }

    public Cookie cookie() {
        this.cookie.setDomain(this.domain);
        this.cookie.setPath(this.path);
        this.cookie.setMaxAge(this.mergeMaxAgeAndExpires());
        this.cookie.setSecure(this.secure);
        this.cookie.setHttpOnly(this.httpOnly);
        return this.cookie;
    }

    public void appendAttribute(int n2, int n3, int n4, int n5) {
        if ((n3 -= n2) == 4) {
            this.parse4(n2, n4, n5);
            return;
        }
        if (n3 == 6) {
            this.parse6(n2, n4, n5);
            return;
        }
        if (n3 == 7) {
            this.parse7(n2, n4, n5);
            return;
        }
        if (n3 == 8) {
            this.parse8(n2, n4, n5);
        }
    }

    private void parse4(int n2, int n3, int n4) {
        if (this.header.regionMatches(true, n2, "Path", 0, 4)) {
            this.path = this.computeValue(n3, n4);
        }
    }

    private void parse6(int n2, int n3, int n4) {
        if (this.header.regionMatches(true, n2, "Domain", 0, 5)) {
            this.domain = this.computeValue(n3, n4);
            return;
        }
        if (this.header.regionMatches(true, n2, "Secure", 0, 5)) {
            this.secure = true;
        }
    }

    private void setMaxAge(String string) {
        try {
            this.maxAge = Math.max(Long.valueOf(string), 0L);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void parse7(int n2, int n3, int n4) {
        if (this.header.regionMatches(true, n2, "Expires", 0, 7)) {
            this.expiresStart = n3;
            this.expiresEnd = n4;
            return;
        }
        if (this.header.regionMatches(true, n2, "Max-Age", 0, 7)) {
            ClientCookieDecoder$CookieBuilder clientCookieDecoder$CookieBuilder = this;
            clientCookieDecoder$CookieBuilder.setMaxAge(clientCookieDecoder$CookieBuilder.computeValue(n3, n4));
        }
    }

    private void parse8(int n2, int n3, int n4) {
        if (this.header.regionMatches(true, n2, "HTTPOnly", 0, 8)) {
            this.httpOnly = true;
        }
    }

    private String computeValue(int n2, int n3) {
        if (n2 == -1 || n2 == n3) {
            return null;
        }
        return this.header.substring(n2, n3);
    }
}

