/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.ClientCookieEncoder$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.Cookie;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.CookieEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.CookieUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.DefaultCookie;
import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new ClientCookieEncoder$1();

    private ClientCookieEncoder(boolean bl) {
        super(bl);
    }

    public final String encode(String string, String string2) {
        return this.encode((Cookie)new DefaultCookie(string, string2));
    }

    public final String encode(Cookie cookie) {
        StringBuilder stringBuilder = CookieUtil.stringBuilder();
        this.encode(stringBuilder, ObjectUtil.checkNotNull(cookie, "cookie"));
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    public final String encode(Cookie ... object) {
        if (((Cookie[])ObjectUtil.checkNotNull(object, "cookies")).length == 0) {
            return null;
        }
        StringBuilder stringBuilder = CookieUtil.stringBuilder();
        if (this.strict) {
            if (((Object)object).length == 1) {
                this.encode(stringBuilder, (Cookie)object[0]);
            } else {
                Object object2 = object;
                Cookie[] cookieArray = (Cookie[])Arrays.copyOf(object2, ((Object)object2).length);
                Arrays.sort(cookieArray, COOKIE_COMPARATOR);
                Cookie[] cookieArray2 = cookieArray;
                int n2 = cookieArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Cookie cookie = cookieArray2[i2];
                    this.encode(stringBuilder, cookie);
                }
            }
        } else {
            for (Object object3 : object) {
                this.encode(stringBuilder, (Cookie)object3);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(stringBuilder);
    }

    public final String encode(Collection<? extends Cookie> cookieArray) {
        if (ObjectUtil.checkNotNull(cookieArray, "cookies").isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = CookieUtil.stringBuilder();
        if (this.strict) {
            if (cookieArray.size() == 1) {
                this.encode(stringBuilder, (Cookie)cookieArray.iterator().next());
            } else {
                cookieArray = cookieArray.toArray(new Cookie[cookieArray.size()]);
                Arrays.sort(cookieArray, COOKIE_COMPARATOR);
                Cookie[] cookieArray2 = cookieArray;
                int n2 = cookieArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Cookie cookie = cookieArray2[i2];
                    this.encode(stringBuilder, cookie);
                }
            }
        } else {
            for (Cookie cookie : cookieArray) {
                this.encode(stringBuilder, cookie);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(stringBuilder);
    }

    public final String encode(Iterable<? extends Cookie> cookieArray) {
        if (!(cookieArray = ObjectUtil.checkNotNull(cookieArray, "cookies").iterator()).hasNext()) {
            return null;
        }
        StringBuilder stringBuilder = CookieUtil.stringBuilder();
        if (this.strict) {
            Cookie cookie = (Cookie)cookieArray.next();
            if (!cookieArray.hasNext()) {
                this.encode(stringBuilder, cookie);
            } else {
                ArrayList<Cookie> arrayList = InternalThreadLocalMap.get().arrayList();
                arrayList.add(cookie);
                while (cookieArray.hasNext()) {
                    arrayList.add((Cookie)cookieArray.next());
                }
                ArrayList<Cookie> arrayList2 = arrayList;
                cookieArray = arrayList2.toArray(new Cookie[arrayList2.size()]);
                Arrays.sort(cookieArray, COOKIE_COMPARATOR);
                for (Cookie cookie2 : cookieArray) {
                    this.encode(stringBuilder, cookie2);
                }
            }
        } else {
            while (cookieArray.hasNext()) {
                this.encode(stringBuilder, (Cookie)cookieArray.next());
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(stringBuilder);
    }

    private void encode(StringBuilder stringBuilder, Cookie cookie) {
        String string = cookie.name();
        String string2 = cookie.value() != null ? cookie.value() : "";
        this.validateCookie(string, string2);
        if (cookie.wrap()) {
            CookieUtil.addQuoted(stringBuilder, string, string2);
            return;
        }
        CookieUtil.add(stringBuilder, string, string2);
    }
}

