/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.CookieUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.DefaultCookie;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.CharBuffer;

public abstract class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final boolean strict;

    protected CookieDecoder(boolean bl) {
        this.strict = bl;
    }

    protected DefaultCookie initCookie(String object, int n2, int n3, int n4, int n5) {
        if (n2 == -1 || n2 == n3) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (n4 == -1) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap((CharSequence)object, n4, n5);
        CharSequence charSequence = CookieUtil.unwrapValue(charBuffer);
        if (charSequence == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)charBuffer);
            return null;
        }
        object = ((String)object).substring(n2, n3);
        if (this.strict && (n2 = CookieUtil.firstInvalidCookieNameOctet((CharSequence)object)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                String string = object;
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)string, (Object)Character.valueOf(string.charAt(n2)));
            }
            return null;
        }
        int n6 = n3 = charSequence.length() != n5 - n4 ? 1 : 0;
        if (this.strict && (n2 = CookieUtil.firstInvalidCookieValueOctet(charSequence)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                CharSequence charSequence2 = charSequence;
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)charSequence2, (Object)Character.valueOf(charSequence2.charAt(n2)));
            }
            return null;
        }
        object = new DefaultCookie((String)object, charSequence.toString());
        ((DefaultCookie)object).setWrap(n3 != 0);
        return object;
    }
}

