/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.CookieUtil;

public abstract class CookieEncoder {
    protected final boolean strict;

    protected CookieEncoder(boolean bl) {
        this.strict = bl;
    }

    protected void validateCookie(String charSequence, String string) {
        if (this.strict) {
            int n2 = CookieUtil.firstInvalidCookieNameOctet(charSequence);
            if (n2 >= 0) {
                throw new IllegalArgumentException("Cookie name contains an invalid char: " + ((String)charSequence).charAt(n2));
            }
            charSequence = CookieUtil.unwrapValue(string);
            if (charSequence == null) {
                throw new IllegalArgumentException("Cookie value wrapping quotes are not balanced: " + string);
            }
            n2 = CookieUtil.firstInvalidCookieValueOctet(charSequence);
            if (n2 >= 0) {
                throw new IllegalArgumentException("Cookie value contains an invalid char: " + string.charAt(n2));
            }
        }
    }
}

