/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie;

import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import java.util.BitSet;

final class CookieUtil {
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = CookieUtil.validCookieAttributeValueOctets();

    private static BitSet validCookieNameOctets() {
        BitSet bitSet = new BitSet();
        for (int i2 = 32; i2 < 127; ++i2) {
            bitSet.set(i2);
        }
        int[] nArray = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9};
        int[] nArray2 = nArray;
        nArray2 = nArray;
        int cfr_ignored_0 = nArray.length;
        for (int i3 = 0; i3 < 19; ++i3) {
            int n2 = nArray2[i3];
            bitSet.set(n2, false);
        }
        return bitSet;
    }

    private static BitSet validCookieValueOctets() {
        int n2;
        BitSet bitSet = new BitSet();
        bitSet.set(33);
        for (n2 = 35; n2 <= 43; ++n2) {
            bitSet.set(n2);
        }
        for (n2 = 45; n2 <= 58; ++n2) {
            bitSet.set(n2);
        }
        for (n2 = 60; n2 <= 91; ++n2) {
            bitSet.set(n2);
        }
        for (n2 = 93; n2 <= 126; ++n2) {
            bitSet.set(n2);
        }
        return bitSet;
    }

    private static BitSet validCookieAttributeValueOctets() {
        BitSet bitSet = new BitSet();
        for (int i2 = 32; i2 < 127; ++i2) {
            bitSet.set(i2);
        }
        bitSet.set(59, false);
        return bitSet;
    }

    static StringBuilder stringBuilder() {
        return InternalThreadLocalMap.get().stringBuilder();
    }

    static String stripTrailingSeparatorOrNull(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return null;
        }
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    static String stripTrailingSeparator(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setLength(stringBuilder2.length() - 2);
        }
        return stringBuilder.toString();
    }

    static void add(StringBuilder stringBuilder, String string, long l2) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(l2);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void add(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(string2);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void add(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void addQuoted(StringBuilder stringBuilder, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append('\"');
        stringBuilder.append(string2);
        stringBuilder.append('\"');
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static int firstInvalidCookieNameOctet(CharSequence charSequence) {
        return CookieUtil.firstInvalidOctet(charSequence, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence charSequence) {
        return CookieUtil.firstInvalidOctet(charSequence, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence charSequence, BitSet bitSet) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (bitSet.get(c2)) continue;
            return i2;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 > 0 && charSequence.charAt(0) == '\"') {
            if (n2 >= 2 && charSequence.charAt(n2 - 1) == '\"') {
                if (n2 == 2) {
                    return "";
                }
                return charSequence.subSequence(1, n2 - 1);
            }
            return null;
        }
        return charSequence;
    }

    static String validateAttributeValue(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).isEmpty()) {
            return null;
        }
        int n2 = CookieUtil.firstInvalidOctet(string2, VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS);
        if (n2 != -1) {
            throw new IllegalArgumentException(string + " contains the prohibited characters: " + string2.charAt(n2));
        }
        return string2;
    }

    private CookieUtil() {
    }
}

