/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaderDateFormat;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.Cookie;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.CookieEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.CookieUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cookie.DefaultCookie;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ServerCookieEncoder
extends CookieEncoder {
    public static final ServerCookieEncoder STRICT = new ServerCookieEncoder(true);
    public static final ServerCookieEncoder LAX = new ServerCookieEncoder(false);

    private ServerCookieEncoder(boolean bl) {
        super(bl);
    }

    public final String encode(String string, String string2) {
        return this.encode((Cookie)new DefaultCookie(string, string2));
    }

    public final String encode(Cookie cookie) {
        Object object = ObjectUtil.checkNotNull(cookie, "cookie").name();
        String string = cookie.value() != null ? cookie.value() : "";
        this.validateCookie((String)object, string);
        StringBuilder stringBuilder = CookieUtil.stringBuilder();
        if (cookie.wrap()) {
            CookieUtil.addQuoted(stringBuilder, (String)object, string);
        } else {
            CookieUtil.add(stringBuilder, (String)object, string);
        }
        if (cookie.maxAge() != Long.MIN_VALUE) {
            CookieUtil.add(stringBuilder, "Max-Age", cookie.maxAge());
            object = new Date(cookie.maxAge() * 1000L + System.currentTimeMillis());
            CookieUtil.add(stringBuilder, "Expires", HttpHeaderDateFormat.get().format((Date)object));
        }
        if (cookie.path() != null) {
            CookieUtil.add(stringBuilder, "Path", cookie.path());
        }
        if (cookie.domain() != null) {
            CookieUtil.add(stringBuilder, "Domain", cookie.domain());
        }
        if (cookie.isSecure()) {
            CookieUtil.add(stringBuilder, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(stringBuilder, "HTTPOnly");
        }
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    private List<String> dedup(List<String> list, Map<String, Integer> map) {
        int n2;
        boolean[] blArray = new boolean[list.size()];
        Object object = map.values().iterator();
        while (object.hasNext()) {
            n2 = object.next();
            blArray[n2] = true;
        }
        object = new ArrayList(map.size());
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray[n2]) continue;
            object.add(list.get(n2));
        }
        return object;
    }

    public final List<String> encode(Cookie ... cookieArray) {
        if (ObjectUtil.checkNotNull(cookieArray, "cookies").length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(cookieArray.length);
        HashMap<String, Integer> hashMap = this.strict && cookieArray.length > 1 ? new HashMap<String, Integer>() : null;
        boolean bl = false;
        for (int i2 = 0; i2 < cookieArray.length; ++i2) {
            Cookie cookie = cookieArray[i2];
            arrayList.add(this.encode(cookie));
            if (hashMap == null) continue;
            bl |= hashMap.put(cookie.name(), i2) != null;
        }
        if (bl) {
            return this.dedup(arrayList, hashMap);
        }
        return arrayList;
    }

    public final List<String> encode(Collection<? extends Cookie> object) {
        if (ObjectUtil.checkNotNull(object, "cookies").isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(object.size());
        HashMap<String, Integer> hashMap = this.strict && object.size() > 1 ? new HashMap<String, Integer>() : null;
        int n2 = 0;
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            Cookie cookie = (Cookie)object.next();
            arrayList.add(this.encode(cookie));
            if (hashMap == null) continue;
            bl |= hashMap.put(cookie.name(), n2++) != null;
        }
        if (bl) {
            return this.dedup(arrayList, hashMap);
        }
        return arrayList;
    }

    public final List<String> encode(Iterable<? extends Cookie> object) {
        boolean bl;
        boolean bl2;
        if (!(object = ObjectUtil.checkNotNull(object, "cookies").iterator()).hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Cookie cookie = (Cookie)object.next();
        HashMap<String, Integer> hashMap = this.strict && object.hasNext() ? new HashMap<String, Integer>() : null;
        int n2 = 0;
        arrayList.add(this.encode(cookie));
        if (hashMap != null) {
            ++n2;
            bl2 = hashMap.put(cookie.name(), 0) != null;
        } else {
            bl2 = bl = false;
        }
        while (object.hasNext()) {
            Cookie cookie2 = (Cookie)object.next();
            arrayList.add(this.encode(cookie2));
            if (hashMap == null) continue;
            bl |= hashMap.put(cookie2.name(), n2++) != null;
        }
        if (bl) {
            return this.dedup(arrayList, hashMap);
        }
        return arrayList;
    }
}

