/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cors;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cors.CorsConfig$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cors.CorsConfig$Builder;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class CorsConfig {
    private final Set<String> origins;
    private final boolean anyOrigin;
    private final boolean enabled;
    private final Set<String> exposeHeaders;
    private final boolean allowCredentials;
    private final long maxAge;
    private final Set<HttpMethod> allowedRequestMethods;
    private final Set<String> allowedRequestHeaders;
    private final boolean allowNullOrigin;
    private final Map<CharSequence, Callable<?>> preflightHeaders;
    private final boolean shortCurcuit;

    private CorsConfig(CorsConfig$Builder corsConfig$Builder) {
        this.origins = new LinkedHashSet<String>(CorsConfig$Builder.access$000(corsConfig$Builder));
        this.anyOrigin = CorsConfig$Builder.access$100(corsConfig$Builder);
        this.enabled = CorsConfig$Builder.access$200(corsConfig$Builder);
        this.exposeHeaders = CorsConfig$Builder.access$300(corsConfig$Builder);
        this.allowCredentials = CorsConfig$Builder.access$400(corsConfig$Builder);
        this.maxAge = CorsConfig$Builder.access$500(corsConfig$Builder);
        this.allowedRequestMethods = CorsConfig$Builder.access$600(corsConfig$Builder);
        this.allowedRequestHeaders = CorsConfig$Builder.access$700(corsConfig$Builder);
        this.allowNullOrigin = CorsConfig$Builder.access$800(corsConfig$Builder);
        this.preflightHeaders = CorsConfig$Builder.access$900(corsConfig$Builder);
        this.shortCurcuit = CorsConfig$Builder.access$1000(corsConfig$Builder);
    }

    public final boolean isCorsSupportEnabled() {
        return this.enabled;
    }

    public final boolean isAnyOriginSupported() {
        return this.anyOrigin;
    }

    public final String origin() {
        if (this.origins.isEmpty()) {
            return "*";
        }
        return this.origins.iterator().next();
    }

    public final Set<String> origins() {
        return this.origins;
    }

    public final boolean isNullOriginAllowed() {
        return this.allowNullOrigin;
    }

    public final Set<String> exposedHeaders() {
        return Collections.unmodifiableSet(this.exposeHeaders);
    }

    public final boolean isCredentialsAllowed() {
        return this.allowCredentials;
    }

    public final long maxAge() {
        return this.maxAge;
    }

    public final Set<HttpMethod> allowedRequestMethods() {
        return Collections.unmodifiableSet(this.allowedRequestMethods);
    }

    public final Set<String> allowedRequestHeaders() {
        return Collections.unmodifiableSet(this.allowedRequestHeaders);
    }

    public final HttpHeaders preflightResponseHeaders() {
        if (this.preflightHeaders.isEmpty()) {
            return HttpHeaders.EMPTY_HEADERS;
        }
        DefaultHttpHeaders defaultHttpHeaders = new DefaultHttpHeaders();
        for (Map.Entry<CharSequence, Callable<?>> entry : this.preflightHeaders.entrySet()) {
            Object obj = CorsConfig.getValue(entry.getValue());
            if (obj instanceof Iterable) {
                ((HttpHeaders)defaultHttpHeaders).add(entry.getKey(), (Iterable)obj);
                continue;
            }
            ((HttpHeaders)defaultHttpHeaders).add(entry.getKey(), obj);
        }
        return defaultHttpHeaders;
    }

    public final boolean isShortCurcuit() {
        return this.shortCurcuit;
    }

    private static <T> T getValue(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not generate value for callable [" + callable + ']', exception);
        }
    }

    public final String toString() {
        return StringUtil.simpleClassName(this) + "[enabled=" + this.enabled + ", origins=" + this.origins + ", anyOrigin=" + this.anyOrigin + ", exposedHeaders=" + this.exposeHeaders + ", isCredentialsAllowed=" + this.allowCredentials + ", maxAge=" + this.maxAge + ", allowedRequestMethods=" + this.allowedRequestMethods + ", allowedRequestHeaders=" + this.allowedRequestHeaders + ", preflightHeaders=" + this.preflightHeaders + ']';
    }

    public static CorsConfig$Builder withAnyOrigin() {
        return new CorsConfig$Builder();
    }

    public static CorsConfig$Builder withOrigin(String string) {
        if ("*".equals(string)) {
            return new CorsConfig$Builder();
        }
        return new CorsConfig$Builder(string);
    }

    public static CorsConfig$Builder withOrigins(String ... stringArray) {
        return new CorsConfig$Builder(stringArray);
    }

    /* synthetic */ CorsConfig(CorsConfig$Builder corsConfig$Builder, CorsConfig$1 corsConfig$1) {
        this(corsConfig$Builder);
    }
}

