/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.cors;

import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.cors.CorsConfig;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;

public class CorsHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CorsHandler.class);
    private static final String ANY_ORIGIN = "*";
    private final CorsConfig config;
    private HttpRequest request;

    public CorsHandler(CorsConfig corsConfig) {
        this.config = corsConfig;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.config.isCorsSupportEnabled() && object instanceof HttpRequest) {
            this.request = (HttpRequest)object;
            if (CorsHandler.isPreflightRequest(this.request)) {
                this.handlePreflight(channelHandlerContext, this.request);
                return;
            }
            if (this.config.isShortCurcuit() && !this.validateOrigin()) {
                CorsHandler.forbidden(channelHandlerContext, this.request);
                return;
            }
        }
        channelHandlerContext.fireChannelRead(object);
    }

    private void handlePreflight(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(httpRequest.getProtocolVersion(), HttpResponseStatus.OK);
        if (this.setOrigin(defaultFullHttpResponse)) {
            this.setAllowMethods(defaultFullHttpResponse);
            this.setAllowHeaders(defaultFullHttpResponse);
            this.setAllowCredentials(defaultFullHttpResponse);
            this.setMaxAge(defaultFullHttpResponse);
            this.setPreflightHeaders(defaultFullHttpResponse);
        }
        ReferenceCountUtil.release(httpRequest);
        CorsHandler.respond(channelHandlerContext, httpRequest, defaultFullHttpResponse);
    }

    private void setPreflightHeaders(HttpResponse httpResponse) {
        httpResponse.headers().add(this.config.preflightResponseHeaders());
    }

    private boolean setOrigin(HttpResponse httpResponse) {
        String string = this.request.headers().get("Origin");
        if (string != null) {
            if ("null".equals(string) && this.config.isNullOriginAllowed()) {
                CorsHandler.setAnyOrigin(httpResponse);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(httpResponse);
                    CorsHandler.setVaryHeader(httpResponse);
                } else {
                    CorsHandler.setAnyOrigin(httpResponse);
                }
                return true;
            }
            if (this.config.origins().contains(string)) {
                CorsHandler.setOrigin(httpResponse, string);
                CorsHandler.setVaryHeader(httpResponse);
                return true;
            }
            logger.debug("Request origin [" + string + "] was not among the configured origins " + this.config.origins());
        }
        return false;
    }

    private boolean validateOrigin() {
        if (this.config.isAnyOriginSupported()) {
            return true;
        }
        String string = this.request.headers().get("Origin");
        if (string == null) {
            return true;
        }
        if ("null".equals(string) && this.config.isNullOriginAllowed()) {
            return true;
        }
        return this.config.origins().contains(string);
    }

    private void echoRequestOrigin(HttpResponse httpResponse) {
        CorsHandler.setOrigin(httpResponse, this.request.headers().get("Origin"));
    }

    private static void setVaryHeader(HttpResponse httpResponse) {
        httpResponse.headers().set("Vary", (Object)"Origin");
    }

    private static void setAnyOrigin(HttpResponse httpResponse) {
        CorsHandler.setOrigin(httpResponse, ANY_ORIGIN);
    }

    private static void setOrigin(HttpResponse httpResponse, String string) {
        httpResponse.headers().set("Access-Control-Allow-Origin", (Object)string);
    }

    private void setAllowCredentials(HttpResponse httpResponse) {
        if (this.config.isCredentialsAllowed() && !httpResponse.headers().get("Access-Control-Allow-Origin").equals(ANY_ORIGIN)) {
            httpResponse.headers().set("Access-Control-Allow-Credentials", (Object)"true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest httpRequest) {
        HttpHeaders httpHeaders = httpRequest.headers();
        return httpRequest.getMethod().equals(HttpMethod.OPTIONS) && httpHeaders.contains("Origin") && httpHeaders.contains("Access-Control-Request-Method");
    }

    private void setExposeHeaders(HttpResponse httpResponse) {
        if (!this.config.exposedHeaders().isEmpty()) {
            httpResponse.headers().set("Access-Control-Expose-Headers", (Iterable<?>)this.config.exposedHeaders());
        }
    }

    private void setAllowMethods(HttpResponse httpResponse) {
        httpResponse.headers().set("Access-Control-Allow-Methods", (Iterable<?>)this.config.allowedRequestMethods());
    }

    private void setAllowHeaders(HttpResponse httpResponse) {
        httpResponse.headers().set("Access-Control-Allow-Headers", (Iterable<?>)this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse httpResponse) {
        httpResponse.headers().set("Access-Control-Max-Age", (Object)this.config.maxAge());
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        HttpResponse httpResponse;
        if (this.config.isCorsSupportEnabled() && object instanceof HttpResponse && this.setOrigin(httpResponse = (HttpResponse)object)) {
            this.setAllowCredentials(httpResponse);
            this.setExposeHeaders(httpResponse);
        }
        channelHandlerContext.writeAndFlush(object, channelPromise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.error("Caught error in CorsHandler", throwable);
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    private static void forbidden(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        CorsHandler.respond(channelHandlerContext, httpRequest, new DefaultFullHttpResponse(httpRequest.getProtocolVersion(), HttpResponseStatus.FORBIDDEN));
        ReferenceCountUtil.release(httpRequest);
    }

    private static void respond(ChannelHandlerContext object, HttpRequest httpRequest, HttpResponse httpResponse) {
        boolean bl = HttpHeaders.isKeepAlive(httpRequest);
        HttpHeaders.setKeepAlive(httpResponse, bl);
        object = object.writeAndFlush(httpResponse);
        if (!bl) {
            object.addListener(ChannelFutureListener.CLOSE);
        }
    }
}

