/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.AbstractHttpData;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class AbstractDiskHttpData
extends AbstractHttpData {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractDiskHttpData.class);
    protected File file;
    private boolean isRenamed;
    private FileChannel fileChannel;

    protected AbstractDiskHttpData(String string, Charset charset, long l2) {
        super(string, charset, l2);
    }

    protected abstract String getDiskFilename();

    protected abstract String getPrefix();

    protected abstract String getBaseDirectory();

    protected abstract String getPostfix();

    protected abstract boolean deleteOnExit();

    private File tempFile() {
        Object object = this.getDiskFilename();
        object = object != null ? "_" + (String)object : this.getPostfix();
        object = this.getBaseDirectory() == null ? File.createTempFile(this.getPrefix(), (String)object) : File.createTempFile(this.getPrefix(), (String)object, new File(this.getBaseDirectory()));
        if (this.deleteOnExit()) {
            ((File)object).deleteOnExit();
        }
        return object;
    }

    @Override
    public void setContent(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
        try {
            this.size = byteBuf.readableBytes();
            if (this.definedSize > 0L && this.definedSize < this.size) {
                throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
            }
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (byteBuf.readableBytes() == 0) {
                this.file.createNewFile();
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = byteBuf.nioBuffer();
                int n2 = 0;
                while ((long)n2 < this.size) {
                    n2 += fileChannel.write(byteBuffer);
                }
                ByteBuf byteBuf2 = byteBuf;
                byteBuf2.readerIndex(byteBuf2.readerIndex() + n2);
                fileChannel.force(false);
            }
            finally {
                fileOutputStream.close();
            }
            this.completed = true;
            return;
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        if (byteBuf != null) {
            try {
                int n2 = byteBuf.readableBytes();
                if (this.definedSize > 0L && this.definedSize < this.size + (long)n2) {
                    throw new IOException("Out of size: " + (this.size + (long)n2) + " > " + this.definedSize);
                }
                ByteBuffer byteBuffer = byteBuf.nioBufferCount() == 1 ? byteBuf.nioBuffer() : byteBuf.copy().nioBuffer();
                int n3 = 0;
                if (this.file == null) {
                    this.file = this.tempFile();
                }
                if (this.fileChannel == null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                    this.fileChannel = fileOutputStream.getChannel();
                }
                while (n3 < n2) {
                    n3 += this.fileChannel.write(byteBuffer);
                }
                this.size += (long)n2;
                ByteBuf byteBuf2 = byteBuf;
                byteBuf2.readerIndex(byteBuf2.readerIndex() + n3);
            }
            finally {
                byteBuf.release();
            }
        }
        if (bl) {
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (this.fileChannel == null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                this.fileChannel = fileOutputStream.getChannel();
            }
            this.fileChannel.force(false);
            this.fileChannel.close();
            this.fileChannel = null;
            this.completed = true;
            return;
        }
        if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
    }

    @Override
    public void setContent(File file) {
        if (this.file != null) {
            this.delete();
        }
        this.file = file;
        this.size = file.length();
        this.isRenamed = true;
        this.completed = true;
    }

    @Override
    public void setContent(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (this.file != null) {
            this.delete();
        }
        this.file = this.tempFile();
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        int n2 = 0;
        try {
            FileChannel fileChannel = fileOutputStream.getChannel();
            byte[] byArray = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n3 = inputStream.read(byArray);
            while (n3 > 0) {
                byteBuffer.position(n3).flip();
                n2 += fileChannel.write(byteBuffer);
                n3 = inputStream.read(byArray);
            }
            fileChannel.force(false);
        }
        finally {
            fileOutputStream.close();
        }
        this.size = n2;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            this.file.delete();
            this.file = null;
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.isRenamed = true;
        this.completed = true;
    }

    @Override
    public void delete() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.force(false);
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close a file.", iOException);
            }
            this.fileChannel = null;
        }
        if (!this.isRenamed) {
            if (this.file != null && this.file.exists()) {
                this.file.delete();
            }
            this.file = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.file == null) {
            return EmptyArrays.EMPTY_BYTES;
        }
        return AbstractDiskHttpData.readFrom(this.file);
    }

    @Override
    public ByteBuf getByteBuf() {
        if (this.file == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
        return Unpooled.wrappedBuffer(byArray);
    }

    @Override
    public ByteBuf getChunk(int n2) {
        int n3;
        int n4;
        if (this.file == null || n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (this.fileChannel == null) {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            this.fileChannel = fileInputStream.getChannel();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.fileChannel.read(byteBuffer);
            if (n4 != -1) continue;
            this.fileChannel.close();
            this.fileChannel = null;
            break;
        }
        if (n3 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        byteBuffer.flip();
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byteBuffer);
        byteBuf.readerIndex(0);
        byteBuf.writerIndex(n3);
        return byteBuf;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset charset) {
        if (this.file == null) {
            return "";
        }
        if (charset == null) {
            byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
            return new String(byArray, HttpConstants.DEFAULT_CHARSET.name());
        }
        byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
        return new String(byArray, charset.name());
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean renameTo(File file) {
        long l2;
        IOException iOException;
        block25: {
            Object object2;
            if (file == null) {
                throw new NullPointerException("dest");
            }
            if (this.file == null) {
                throw new IOException("No file defined so cannot be renamed");
            }
            if (this.file.renameTo(file)) {
                this.file = file;
                this.isRenamed = true;
                return true;
            }
            iOException = null;
            Object object = null;
            FileOutputStream fileOutputStream = null;
            long l3 = 8196L;
            try {
                object = new FileInputStream(this.file);
                fileOutputStream = new FileOutputStream(file);
                object2 = ((FileInputStream)object).getChannel();
                FileChannel fileChannel = fileOutputStream.getChannel();
                for (l2 = 0L; l2 < this.size; l2 += ((FileChannel)object2).transferTo(l2, l3, fileChannel)) {
                    if (l3 >= this.size - l2) continue;
                    l3 = this.size - l2;
                }
            }
            catch (IOException iOException2) {
                IOException iOException5 = iOException2;
                iOException = iOException2;
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException6) {
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException6);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException7) {
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException7);
                    }
                }
                break block25;
            }
            catch (Throwable throwable) {
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException3) {
                        object = iOException3;
                        iOException = iOException3;
                    }
                }
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException9) {
                    if (iOException == null) throw throwable;
                    logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException9);
                }
                throw throwable;
            }
            try {
                ((FileInputStream)object).close();
            }
            catch (IOException iOException4) {
                object2 = iOException4;
                iOException = iOException4;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException3) {
                if (iOException == null) {
                    iOException = iOException3;
                }
                logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException3);
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        if (l2 == this.size) {
            this.file.delete();
            this.file = file;
            this.isRenamed = true;
            return true;
        }
        file.delete();
        return false;
    }

    private static byte[] readFrom(File object) {
        long l2 = ((File)object).length();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        object = new FileInputStream((File)object);
        byte[] byArray = new byte[(int)l2];
        try {
            FileChannel fileChannel = ((FileInputStream)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n2 = 0;
            while ((long)n2 < l2) {
                n2 += fileChannel.read(byteBuffer);
            }
        }
        finally {
            ((FileInputStream)object).close();
        }
        return byArray;
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

