/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.Attribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.DiskAttribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.DiskFileUpload;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.FileUpload;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.MemoryAttribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.MemoryFileUpload;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.MixedAttribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.MixedFileUpload;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultHttpDataFactory
implements HttpDataFactory {
    public static final long MINSIZE = 16384L;
    private final boolean useDisk;
    private final boolean checkSize;
    private long minSize;
    private final Map<HttpRequest, List<HttpData>> requestFileDeleteMap = PlatformDependent.newConcurrentHashMap();

    public DefaultHttpDataFactory() {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = 16384L;
    }

    public DefaultHttpDataFactory(boolean bl) {
        this.useDisk = bl;
        this.checkSize = false;
    }

    public DefaultHttpDataFactory(long l2) {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = l2;
    }

    private List<HttpData> getList(HttpRequest httpRequest) {
        List<HttpData> list = this.requestFileDeleteMap.get(httpRequest);
        if (list == null) {
            list = new ArrayList<HttpData>();
            this.requestFileDeleteMap.put(httpRequest, list);
        }
        return list;
    }

    @Override
    public Attribute createAttribute(HttpRequest list, String object) {
        if (this.useDisk) {
            object = new DiskAttribute((String)object);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        if (this.checkSize) {
            object = new MixedAttribute((String)object, this.minSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        return new MemoryAttribute((String)object);
    }

    @Override
    public Attribute createAttribute(HttpRequest list, String string, String string2) {
        if (this.useDisk) {
            Attribute attribute;
            try {
                attribute = new DiskAttribute(string, string2);
            }
            catch (IOException iOException) {
                attribute = new MixedAttribute(string, string2, this.minSize);
            }
            list = this.getList((HttpRequest)((Object)list));
            list.add(attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute mixedAttribute = new MixedAttribute(string, string2, this.minSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add(mixedAttribute);
            return mixedAttribute;
        }
        try {
            return new MemoryAttribute(string, string2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    @Override
    public FileUpload createFileUpload(HttpRequest list, String object, String string, String string2, String string3, Charset charset, long l2) {
        if (this.useDisk) {
            object = new DiskFileUpload((String)object, string, string2, string3, charset, l2);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        if (this.checkSize) {
            object = new MixedFileUpload((String)object, string, string2, string3, charset, l2, this.minSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        return new MemoryFileUpload((String)object, string, string2, string3, charset, l2);
    }

    @Override
    public void removeHttpDataFromClean(HttpRequest object, InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData instanceof HttpData) {
            object = this.getList((HttpRequest)object);
            object.remove(interfaceHttpData);
        }
    }

    @Override
    public void cleanRequestHttpDatas(HttpRequest object) {
        if ((object = this.requestFileDeleteMap.remove(object)) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                HttpData httpData = (HttpData)iterator.next();
                httpData.delete();
            }
            object.clear();
        }
    }

    @Override
    public void cleanAllHttpDatas() {
        Iterator<Map.Entry<HttpRequest, List<HttpData>>> iterator = this.requestFileDeleteMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            iterator.remove();
            if ((object = object.getValue()) == null) continue;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                HttpData httpData = (HttpData)iterator2.next();
                httpData.delete();
            }
            object.clear();
        }
    }
}

