/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.AbstractDiskHttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.Attribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpData$HttpDataType;
import java.io.IOException;

public class DiskAttribute
extends AbstractDiskHttpData
implements Attribute {
    public static String baseDirectory;
    public static boolean deleteOnExitTemporaryFile;
    public static final String prefix = "Attr_";
    public static final String postfix = ".att";

    public DiskAttribute(String string) {
        super(string, HttpConstants.DEFAULT_CHARSET, 0L);
    }

    public DiskAttribute(String string, String string2) {
        super(string, HttpConstants.DEFAULT_CHARSET, 0L);
        this.setValue(string2);
    }

    @Override
    public InterfaceHttpData$HttpDataType getHttpDataType() {
        return InterfaceHttpData$HttpDataType.Attribute;
    }

    @Override
    public String getValue() {
        byte[] byArray = this.get();
        return new String(byArray, this.charset.name());
    }

    @Override
    public void setValue(String object) {
        if (object == null) {
            throw new NullPointerException("value");
        }
        byte[] byArray = ((String)object).getBytes(this.charset.name());
        object = byArray;
        object = Unpooled.wrappedBuffer(byArray);
        if (this.definedSize > 0L) {
            this.definedSize = ((ByteBuf)object).readableBytes();
        }
        this.setContent((ByteBuf)object);
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        int n2 = byteBuf.readableBytes();
        if (this.definedSize > 0L && this.definedSize < this.size + (long)n2) {
            this.definedSize = this.size + (long)n2;
        }
        super.addContent(byteBuf, bl);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        object = (Attribute)object;
        return this.getName().equalsIgnoreCase(object.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData interfaceHttpData) {
        if (!(interfaceHttpData instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)interfaceHttpData.getHttpDataType()));
        }
        return this.compareTo((Attribute)interfaceHttpData);
    }

    @Override
    public int compareTo(Attribute attribute) {
        return this.getName().compareToIgnoreCase(attribute.getName());
    }

    public String toString() {
        try {
            return this.getName() + '=' + this.getValue();
        }
        catch (IOException iOException) {
            return this.getName() + "=IoException";
        }
    }

    @Override
    protected boolean deleteOnExit() {
        return deleteOnExitTemporaryFile;
    }

    @Override
    protected String getBaseDirectory() {
        return baseDirectory;
    }

    @Override
    protected String getDiskFilename() {
        return this.getName() + postfix;
    }

    @Override
    protected String getPostfix() {
        return postfix;
    }

    @Override
    protected String getPrefix() {
        return prefix;
    }

    @Override
    public Attribute copy() {
        DiskAttribute diskAttribute = new DiskAttribute(this.getName());
        diskAttribute.setCharset(this.getCharset());
        ByteBuf byteBuf = this.content();
        if (byteBuf != null) {
            try {
                diskAttribute.setContent(byteBuf.copy());
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }
        return diskAttribute;
    }

    @Override
    public Attribute duplicate() {
        DiskAttribute diskAttribute = new DiskAttribute(this.getName());
        diskAttribute.setCharset(this.getCharset());
        ByteBuf byteBuf = this.content();
        if (byteBuf != null) {
            try {
                diskAttribute.setContent(byteBuf.duplicate());
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }
        return diskAttribute;
    }

    @Override
    public Attribute retain(int n2) {
        super.retain(n2);
        return this;
    }

    @Override
    public Attribute retain() {
        super.retain();
        return this;
    }

    static {
        deleteOnExitTemporaryFile = true;
    }
}

