/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.Attribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.FileUpload;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadNoBackArrayException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadOptimize;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$TransferEncodingMechanism;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$EndOfDataDecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$MultiPartStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$NotEnoughDataDecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostMultipartRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private String multipartDataBoundary;
    private String multipartMixedBoundary;
    private HttpPostRequestDecoder$MultiPartStatus currentStatus = HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED;
    private Map<CharSequence, Attribute> currentFieldAttributes;
    private FileUpload currentFileUpload;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    public HttpPostMultipartRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        if (httpDataFactory == null) {
            throw new NullPointerException("factory");
        }
        if (httpRequest == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.request = httpRequest;
        this.charset = charset;
        this.factory = httpDataFactory;
        HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
        httpPostMultipartRequestDecoder.setMultipart(httpPostMultipartRequestDecoder.request.headers().get("Content-Type"));
        if (httpRequest instanceof HttpContent) {
            this.offer((HttpContent)((Object)httpRequest));
            return;
        }
        this.undecodedChunk = Unpooled.buffer();
        this.parseBody();
    }

    private void setMultipart(String stringArray) {
        if ((stringArray = HttpPostRequestDecoder.getMultipartDataBoundary((String)stringArray)) != null) {
            this.multipartDataBoundary = stringArray[0];
            if (stringArray.length > 1 && stringArray[1] != null) {
                this.charset = Charset.forName(stringArray[1]);
            }
        } else {
            this.multipartDataBoundary = null;
        }
        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostMultipartRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return true;
    }

    @Override
    public void setDiscardThreshold(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("discardThreshold must be >= 0");
        }
        this.discardThreshold = n2;
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String object) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        if ((object = this.bodyMapHttpData.get(object)) != null) {
            return (InterfaceHttpData)object.get(0);
        }
        return null;
    }

    @Override
    public HttpPostMultipartRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        ByteBuf byteBuf = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = byteBuf.copy();
        } else {
            this.undecodedChunk.writeBytes(byteBuf);
        }
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            this.undecodedChunk.discardReadBytes();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder$EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyMultipart();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    private void parseBodyMultipart() {
        if (this.undecodedChunk == null || this.undecodedChunk.readableBytes() == 0) {
            return;
        }
        HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
        InterfaceHttpData interfaceHttpData = httpPostMultipartRequestDecoder.decodeMultipart(httpPostMultipartRequestDecoder.currentStatus);
        while (interfaceHttpData != null) {
            this.addHttpData(interfaceHttpData);
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) break;
            HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder2 = this;
            interfaceHttpData = httpPostMultipartRequestDecoder2.decodeMultipart(httpPostMultipartRequestDecoder2.currentStatus);
        }
    }

    private InterfaceHttpData decodeMultipart(HttpPostRequestDecoder$MultiPartStatus object) {
        switch (object) {
            case NOTSTARTED: {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case PREAMBLE: {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case HEADERDELIMITER: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.findMultipartDelimiter(httpPostMultipartRequestDecoder.multipartDataBoundary, HttpPostRequestDecoder$MultiPartStatus.DISPOSITION, HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE);
            }
            case DISPOSITION: {
                return this.findMultipartDisposition();
            }
            case FIELD: {
                object = null;
                Attribute attribute = this.currentFieldAttributes.get("charset");
                if (attribute != null) {
                    try {
                        object = Charset.forName(attribute.getValue());
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
                    }
                }
                attribute = this.currentFieldAttributes.get("name");
                if (this.currentAttribute == null) {
                    try {
                        this.currentAttribute = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute.getValue()));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    if (object != null) {
                        this.currentAttribute.setCharset((Charset)object);
                    }
                }
                try {
                    HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                    httpPostMultipartRequestDecoder.loadFieldMultipart(httpPostMultipartRequestDecoder.multipartDataBoundary);
                }
                catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
                    return null;
                }
                object = this.currentAttribute;
                this.currentAttribute = null;
                this.currentFieldAttributes = null;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
                return object;
            }
            case FILEUPLOAD: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.getFileUpload(httpPostMultipartRequestDecoder.multipartDataBoundary);
            }
            case MIXEDDELIMITER: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.findMultipartDelimiter(httpPostMultipartRequestDecoder.multipartMixedBoundary, HttpPostRequestDecoder$MultiPartStatus.MIXEDDISPOSITION, HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER);
            }
            case MIXEDDISPOSITION: {
                return this.findMultipartDisposition();
            }
            case MIXEDFILEUPLOAD: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.getFileUpload(httpPostMultipartRequestDecoder.multipartMixedBoundary);
            }
            case PREEPILOGUE: {
                return null;
            }
            case EPILOGUE: {
                return null;
            }
        }
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("Shouldn't reach here.");
    }

    void skipControlCharacters() {
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize;
        try {
            httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil$SeekAheadNoBackArrayException httpPostBodyUtil$SeekAheadNoBackArrayException) {
            try {
                this.skipControlCharactersStandard();
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
            }
        }
        while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
            char c2;
            if (Character.isISOControl(c2 = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF)) || Character.isWhitespace(c2)) continue;
            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(1);
            return;
        }
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException("Access out of bounds");
    }

    void skipControlCharactersStandard() {
        char c2;
        while (Character.isISOControl(c2 = (char)this.undecodedChunk.readUnsignedByte()) || Character.isWhitespace(c2)) {
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
    }

    private InterfaceHttpData findMultipartDelimiter(String string, HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus, HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus2) {
        String string2;
        int n2 = this.undecodedChunk.readerIndex();
        try {
            this.skipControlCharacters();
        }
        catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n2);
            return null;
        }
        this.skipOneLine();
        try {
            string2 = this.readDelimiter(string);
        }
        catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n2);
            return null;
        }
        if (string2.equals(string)) {
            this.currentStatus = httpPostRequestDecoder$MultiPartStatus;
            return this.decodeMultipart(httpPostRequestDecoder$MultiPartStatus);
        }
        if (string2.equals(string + "--")) {
            this.currentStatus = httpPostRequestDecoder$MultiPartStatus2;
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER) {
                this.currentFieldAttributes = null;
                return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER);
            }
            return null;
        }
        this.undecodedChunk.readerIndex(n2);
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("No Multipart delimiter found");
    }

    private InterfaceHttpData findMultipartDisposition() {
        int n2 = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
            this.currentFieldAttributes = new TreeMap<CharSequence, Attribute>(CaseIgnoringComparator.INSTANCE);
        }
        while (!this.skipOneLine()) {
            Object object;
            Object object2;
            try {
                this.skipControlCharacters();
                object2 = this.readLine();
            }
            catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
                this.undecodedChunk.readerIndex(n2);
                return null;
            }
            String[] stringArray = HttpPostMultipartRequestDecoder.splitMultipartHeader((String)object2);
            if (stringArray[0].equalsIgnoreCase("Content-Disposition")) {
                boolean bl;
                if (!(this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION ? stringArray[1].equalsIgnoreCase("form-data") : (bl = stringArray[1].equalsIgnoreCase("attachment") || stringArray[1].equalsIgnoreCase("file")))) continue;
                for (int i2 = 2; i2 < stringArray.length; ++i2) {
                    Object object3;
                    object = stringArray[i2].split("=", 2);
                    try {
                        object3 = HttpPostMultipartRequestDecoder.cleanString(object[0]);
                        object = object[1];
                        object = "filename".equals(object3) ? object.substring(1, object.length() - 1) : HttpPostMultipartRequestDecoder.cleanString((String)object);
                        object3 = this.factory.createAttribute(this.request, (String)object3, (String)object);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(object3.getName(), (Attribute)object3);
                }
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("Content-Transfer-Encoding")) {
                try {
                    object2 = this.factory.createAttribute(this.request, "Content-Transfer-Encoding", HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put("Content-Transfer-Encoding", (Attribute)object2);
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("Content-Length")) {
                try {
                    object2 = this.factory.createAttribute(this.request, "Content-Length", HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put("Content-Length", (Attribute)object2);
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("Content-Type")) {
                if (stringArray[1].equalsIgnoreCase("multipart/mixed")) {
                    if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
                        object2 = StringUtil.substringAfter(stringArray[2], '=');
                        this.multipartMixedBoundary = "--" + (String)object2;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER;
                        return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER);
                    }
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException("Mixed Multipart found in a previous Mixed Multipart");
                }
                for (int i3 = 1; i3 < stringArray.length; ++i3) {
                    Object object4;
                    if (stringArray[i3].toLowerCase().startsWith("charset")) {
                        object4 = StringUtil.substringAfter(stringArray[i3], '=');
                        try {
                            object = this.factory.createAttribute(this.request, "charset", HttpPostMultipartRequestDecoder.cleanString((String)object4));
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                        }
                        this.currentFieldAttributes.put("charset", (Attribute)object);
                        continue;
                    }
                    try {
                        object4 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(stringArray[0]), stringArray[i3]);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(object4.getName(), (Attribute)object4);
                }
                continue;
            }
            throw new HttpPostRequestDecoder$ErrorDataDecoderException("Unknown Params: " + (String)object2);
        }
        Attribute attribute = this.currentFieldAttributes.get("filename");
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
            if (attribute != null) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD;
                return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD);
            }
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
            return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.FIELD);
        }
        if (attribute != null) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDFILEUPLOAD;
            return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.MIXEDFILEUPLOAD);
        }
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("Filename not found");
    }

    protected InterfaceHttpData getFileUpload(String string) {
        Object object = this.currentFieldAttributes.get("Content-Transfer-Encoding");
        Charset charset = this.charset;
        HttpPostBodyUtil$TransferEncodingMechanism httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BIT7;
        if (object != null) {
            try {
                object = object.getValue().toLowerCase();
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BIT7.value())) {
                charset = HttpPostBodyUtil.US_ASCII;
            } else if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BIT8.value())) {
                charset = HttpPostBodyUtil.ISO_8859_1;
                httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BIT8;
            } else if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value())) {
                httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BINARY;
            } else {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("TransferEncoding Unknown: " + (String)object);
            }
        }
        if ((object = this.currentFieldAttributes.get("charset")) != null) {
            try {
                charset = Charset.forName(object.getValue());
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
            }
        }
        if (this.currentFileUpload == null) {
            long l2;
            object = this.currentFieldAttributes.get("filename");
            Attribute attribute = this.currentFieldAttributes.get("name");
            Object object2 = this.currentFieldAttributes.get("Content-Type");
            Attribute attribute2 = this.currentFieldAttributes.get("Content-Length");
            try {
                l2 = attribute2 != null ? Long.parseLong(attribute2.getValue()) : 0L;
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = 0L;
            }
            try {
                object2 = object2 != null ? object2.getValue() : "application/octet-stream";
                this.currentFileUpload = this.factory.createFileUpload(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute.getValue()), HttpPostMultipartRequestDecoder.cleanString(object.getValue()), (String)object2, httpPostBodyUtil$TransferEncodingMechanism.value(), charset, l2);
            }
            catch (NullPointerException nullPointerException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
        }
        try {
            this.readFileUploadByteMultipart(string);
        }
        catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
            return null;
        }
        if (this.currentFileUpload.isCompleted()) {
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
                this.currentFieldAttributes = null;
            } else {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER;
                this.cleanMixedAttributes();
            }
            object = this.currentFileUpload;
            this.currentFileUpload = null;
            return object;
        }
        return null;
    }

    @Override
    public void destroy() {
        this.checkDestroyed();
        this.cleanFiles();
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
        for (int i2 = this.bodyListHttpDataRank; i2 < this.bodyListHttpData.size(); ++i2) {
            this.bodyListHttpData.get(i2).release();
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpDatas(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }

    private void cleanMixedAttributes() {
        this.currentFieldAttributes.remove("charset");
        this.currentFieldAttributes.remove("Content-Length");
        this.currentFieldAttributes.remove("Content-Transfer-Encoding");
        this.currentFieldAttributes.remove("Content-Type");
        this.currentFieldAttributes.remove("filename");
    }

    private String readLineStandard() {
        int n2 = this.undecodedChunk.readerIndex();
        try {
            ByteBuf byteBuf = Unpooled.buffer(64);
            while (this.undecodedChunk.isReadable()) {
                byte by = this.undecodedChunk.readByte();
                if (by == 13) {
                    by = this.undecodedChunk.getByte(this.undecodedChunk.readerIndex());
                    if (by == 10) {
                        this.undecodedChunk.readByte();
                        return byteBuf.toString(this.charset);
                    }
                    byteBuf.writeByte(13);
                    continue;
                }
                if (by == 10) {
                    return byteBuf.toString(this.charset);
                }
                byteBuf.writeByte(by);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n2);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private String readLine() {
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize;
        try {
            httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil$SeekAheadNoBackArrayException httpPostBodyUtil$SeekAheadNoBackArrayException) {
            return this.readLineStandard();
        }
        int n2 = this.undecodedChunk.readerIndex();
        try {
            ByteBuf byteBuf = Unpooled.buffer(64);
            while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                byte by;
                if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 13) {
                    if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                        if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                            return byteBuf.toString(this.charset);
                        }
                        --httpPostBodyUtil$SeekAheadOptimize.pos;
                        byteBuf.writeByte(13);
                        continue;
                    }
                    byteBuf.writeByte(by);
                    continue;
                }
                if (by == 10) {
                    httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                    return byteBuf.toString(this.charset);
                }
                byteBuf.writeByte(by);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n2);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private String readDelimiterStandard(String string) {
        int n2 = this.undecodedChunk.readerIndex();
        try {
            byte by;
            StringBuilder stringBuilder = new StringBuilder(64);
            int n3 = string.length();
            for (int i2 = 0; this.undecodedChunk.isReadable() && i2 < n3; ++i2) {
                by = this.undecodedChunk.readByte();
                if (by == string.charAt(i2)) {
                    stringBuilder.append((char)by);
                    continue;
                }
                this.undecodedChunk.readerIndex(n2);
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
            }
            if (this.undecodedChunk.isReadable()) {
                by = this.undecodedChunk.readByte();
                if (by == 13) {
                    by = this.undecodedChunk.readByte();
                    if (by == 10) {
                        return stringBuilder.toString();
                    }
                    this.undecodedChunk.readerIndex(n2);
                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                }
                if (by == 10) {
                    return stringBuilder.toString();
                }
                if (by == 45) {
                    stringBuilder.append('-');
                    by = this.undecodedChunk.readByte();
                    if (by == 45) {
                        stringBuilder.append('-');
                        if (this.undecodedChunk.isReadable()) {
                            by = this.undecodedChunk.readByte();
                            if (by == 13) {
                                by = this.undecodedChunk.readByte();
                                if (by == 10) {
                                    return stringBuilder.toString();
                                }
                                this.undecodedChunk.readerIndex(n2);
                                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                            }
                            if (by == 10) {
                                return stringBuilder.toString();
                            }
                            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                            return stringBuilder.toString();
                        }
                        return stringBuilder.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n2);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private String readDelimiter(String string) {
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize;
        try {
            httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil$SeekAheadNoBackArrayException httpPostBodyUtil$SeekAheadNoBackArrayException) {
            return this.readDelimiterStandard(string);
        }
        int n2 = this.undecodedChunk.readerIndex();
        int n3 = string.length();
        try {
            byte by;
            StringBuilder stringBuilder = new StringBuilder(64);
            for (int i2 = 0; httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit && i2 < n3; ++i2) {
                if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == string.charAt(i2)) {
                    stringBuilder.append((char)by);
                    continue;
                }
                this.undecodedChunk.readerIndex(n2);
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
            }
            if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 13) {
                    if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                        if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                            return stringBuilder.toString();
                        }
                        this.undecodedChunk.readerIndex(n2);
                        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                    }
                    this.undecodedChunk.readerIndex(n2);
                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                }
                if (by == 10) {
                    httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                    return stringBuilder.toString();
                }
                if (by == 45) {
                    stringBuilder.append('-');
                    if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit && (by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 45) {
                        stringBuilder.append('-');
                        if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                            if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 13) {
                                if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                                    if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                                        httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                        return stringBuilder.toString();
                                    }
                                    this.undecodedChunk.readerIndex(n2);
                                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                                }
                                this.undecodedChunk.readerIndex(n2);
                                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                            }
                            if (by == 10) {
                                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                return stringBuilder.toString();
                            }
                            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(1);
                            return stringBuilder.toString();
                        }
                        httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                        return stringBuilder.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n2);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private void readFileUploadByteMultipartStandard(String string) {
        int n2 = this.undecodedChunk.readerIndex();
        boolean bl = true;
        int n3 = 0;
        int n4 = this.undecodedChunk.readerIndex();
        boolean bl2 = false;
        while (this.undecodedChunk.isReadable()) {
            byte by = this.undecodedChunk.readByte();
            if (bl) {
                if (by == string.codePointAt(n3)) {
                    if (string.length() != ++n3) continue;
                    bl2 = true;
                    break;
                }
                bl = false;
                n3 = 0;
                if (by == 13) {
                    if (!this.undecodedChunk.isReadable()) continue;
                    by = this.undecodedChunk.readByte();
                    if (by == 10) {
                        bl = true;
                        n3 = 0;
                        n4 = this.undecodedChunk.readerIndex() - 2;
                        continue;
                    }
                    n4 = this.undecodedChunk.readerIndex() - 1;
                    this.undecodedChunk.readerIndex(n4);
                    continue;
                }
                if (by == 10) {
                    bl = true;
                    n3 = 0;
                    n4 = this.undecodedChunk.readerIndex() - 1;
                    continue;
                }
                n4 = this.undecodedChunk.readerIndex();
                continue;
            }
            if (by == 13) {
                if (!this.undecodedChunk.isReadable()) continue;
                by = this.undecodedChunk.readByte();
                if (by == 10) {
                    bl = true;
                    n3 = 0;
                    n4 = this.undecodedChunk.readerIndex() - 2;
                    continue;
                }
                n4 = this.undecodedChunk.readerIndex() - 1;
                this.undecodedChunk.readerIndex(n4);
                continue;
            }
            if (by == 10) {
                bl = true;
                n3 = 0;
                n4 = this.undecodedChunk.readerIndex() - 1;
                continue;
            }
            n4 = this.undecodedChunk.readerIndex();
        }
        ByteBuf byteBuf = this.undecodedChunk.copy(n2, n4 - n2);
        if (bl2) {
            try {
                this.currentFileUpload.addContent(byteBuf, true);
                this.undecodedChunk.readerIndex(n4);
                return;
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
        }
        try {
            this.currentFileUpload.addContent(byteBuf, false);
            this.undecodedChunk.readerIndex(n4);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        catch (IOException iOException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readFileUploadByteMultipart(String string) {
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize;
        try {
            httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil$SeekAheadNoBackArrayException httpPostBodyUtil$SeekAheadNoBackArrayException) {
            this.readFileUploadByteMultipartStandard(string);
            return;
        }
        int n2 = this.undecodedChunk.readerIndex();
        boolean bl = true;
        int n3 = 0;
        int n4 = httpPostBodyUtil$SeekAheadOptimize.pos;
        boolean bl2 = false;
        while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
            block18: {
                byte by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++];
                if (bl) {
                    if (by == string.codePointAt(n3)) {
                        if (string.length() != ++n3) continue;
                        bl2 = true;
                        break;
                    }
                    bl = false;
                    n3 = 0;
                    if (by == 13) {
                        if (httpPostBodyUtil$SeekAheadOptimize.pos >= httpPostBodyUtil$SeekAheadOptimize.limit) continue;
                        if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                            bl = true;
                            n3 = 0;
                            n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 2;
                            continue;
                        }
                        break block18;
                    } else {
                        if (by == 10) {
                            bl = true;
                            n3 = 0;
                            n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 1;
                            continue;
                        }
                        n4 = httpPostBodyUtil$SeekAheadOptimize.pos;
                        continue;
                    }
                }
                if (by == 13) {
                    if (httpPostBodyUtil$SeekAheadOptimize.pos >= httpPostBodyUtil$SeekAheadOptimize.limit) continue;
                    if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                        bl = true;
                        n3 = 0;
                        n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 2;
                        continue;
                    }
                    --httpPostBodyUtil$SeekAheadOptimize.pos;
                } else if (by == 10) {
                    bl = true;
                    n3 = 0;
                    n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 1;
                    continue;
                }
            }
            n4 = --httpPostBodyUtil$SeekAheadOptimize.pos;
        }
        int n5 = httpPostBodyUtil$SeekAheadOptimize.getReadPosition(n4);
        ByteBuf byteBuf = this.undecodedChunk.copy(n2, n5 - n2);
        if (bl2) {
            try {
                this.currentFileUpload.addContent(byteBuf, true);
                this.undecodedChunk.readerIndex(n5);
                return;
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
        }
        try {
            this.currentFileUpload.addContent(byteBuf, false);
            this.undecodedChunk.readerIndex(n5);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        catch (IOException iOException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
    }

    private void loadFieldMultipartStandard(String string) {
        int n2 = this.undecodedChunk.readerIndex();
        try {
            boolean bl = true;
            int n3 = 0;
            int n4 = this.undecodedChunk.readerIndex();
            boolean bl2 = false;
            while (this.undecodedChunk.isReadable()) {
                byte by = this.undecodedChunk.readByte();
                if (bl) {
                    if (by == string.codePointAt(n3)) {
                        if (string.length() != ++n3) continue;
                        bl2 = true;
                        break;
                    }
                    bl = false;
                    n3 = 0;
                    if (by == 13) {
                        if (this.undecodedChunk.isReadable()) {
                            by = this.undecodedChunk.readByte();
                            if (by == 10) {
                                bl = true;
                                n3 = 0;
                                n4 = this.undecodedChunk.readerIndex() - 2;
                                continue;
                            }
                            n4 = this.undecodedChunk.readerIndex() - 1;
                            this.undecodedChunk.readerIndex(n4);
                            continue;
                        }
                        n4 = this.undecodedChunk.readerIndex() - 1;
                        continue;
                    }
                    if (by == 10) {
                        bl = true;
                        n3 = 0;
                        n4 = this.undecodedChunk.readerIndex() - 1;
                        continue;
                    }
                    n4 = this.undecodedChunk.readerIndex();
                    continue;
                }
                if (by == 13) {
                    if (this.undecodedChunk.isReadable()) {
                        by = this.undecodedChunk.readByte();
                        if (by == 10) {
                            bl = true;
                            n3 = 0;
                            n4 = this.undecodedChunk.readerIndex() - 2;
                            continue;
                        }
                        n4 = this.undecodedChunk.readerIndex() - 1;
                        this.undecodedChunk.readerIndex(n4);
                        continue;
                    }
                    n4 = this.undecodedChunk.readerIndex() - 1;
                    continue;
                }
                if (by == 10) {
                    bl = true;
                    n3 = 0;
                    n4 = this.undecodedChunk.readerIndex() - 1;
                    continue;
                }
                n4 = this.undecodedChunk.readerIndex();
            }
            if (bl2) {
                try {
                    this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n4 - n2), true);
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                }
            }
            try {
                this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n4 - n2), false);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            this.undecodedChunk.readerIndex(n4);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
            this.undecodedChunk.readerIndex(n4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFieldMultipart(String string) {
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize;
        try {
            httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil$SeekAheadNoBackArrayException httpPostBodyUtil$SeekAheadNoBackArrayException) {
            this.loadFieldMultipartStandard(string);
            return;
        }
        int n2 = this.undecodedChunk.readerIndex();
        try {
            boolean bl = true;
            int n3 = 0;
            int n4 = httpPostBodyUtil$SeekAheadOptimize.pos;
            boolean bl2 = false;
            while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                block20: {
                    byte by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++];
                    if (bl) {
                        if (by == string.codePointAt(n3)) {
                            if (string.length() != ++n3) continue;
                            bl2 = true;
                            break;
                        }
                        bl = false;
                        n3 = 0;
                        if (by == 13) {
                            if (httpPostBodyUtil$SeekAheadOptimize.pos >= httpPostBodyUtil$SeekAheadOptimize.limit) continue;
                            if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                                bl = true;
                                n3 = 0;
                                n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 2;
                                continue;
                            }
                            break block20;
                        } else {
                            if (by == 10) {
                                bl = true;
                                n3 = 0;
                                n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 1;
                                continue;
                            }
                            n4 = httpPostBodyUtil$SeekAheadOptimize.pos;
                            continue;
                        }
                    }
                    if (by == 13) {
                        if (httpPostBodyUtil$SeekAheadOptimize.pos >= httpPostBodyUtil$SeekAheadOptimize.limit) continue;
                        if ((by = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                            bl = true;
                            n3 = 0;
                            n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 2;
                            continue;
                        }
                        --httpPostBodyUtil$SeekAheadOptimize.pos;
                    } else if (by == 10) {
                        bl = true;
                        n3 = 0;
                        n4 = httpPostBodyUtil$SeekAheadOptimize.pos - 1;
                        continue;
                    }
                }
                n4 = --httpPostBodyUtil$SeekAheadOptimize.pos;
            }
            int n5 = httpPostBodyUtil$SeekAheadOptimize.getReadPosition(n4);
            if (bl2) {
                try {
                    this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n5 - n2), true);
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                }
                this.undecodedChunk.readerIndex(n5);
                return;
            }
            try {
                this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n5 - n2), false);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            this.undecodedChunk.readerIndex(n5);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
    }

    private static String cleanString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ':') {
                stringBuilder.append(' ');
                continue;
            }
            if (c2 == ',') {
                stringBuilder.append(' ');
                continue;
            }
            if (c2 == '=') {
                stringBuilder.append(' ');
                continue;
            }
            if (c2 == ';') {
                stringBuilder.append(' ');
                continue;
            }
            if (c2 == '\t') {
                stringBuilder.append(' ');
                continue;
            }
            if (c2 == '\"') continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString().trim();
    }

    private boolean skipOneLine() {
        if (!this.undecodedChunk.isReadable()) {
            return false;
        }
        byte by = this.undecodedChunk.readByte();
        if (by == 13) {
            if (!this.undecodedChunk.isReadable()) {
                this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                return false;
            }
            by = this.undecodedChunk.readByte();
            if (by == 10) {
                return true;
            }
            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 2);
            return false;
        }
        if (by == 10) {
            return true;
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
        return false;
    }

    private static String[] splitMultipartHeader(String stringArray) {
        int n2;
        int n3;
        int n4;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (n4 = n3 = HttpPostBodyUtil.findNonWhitespace((String)stringArray, 0); n4 < stringArray.length(); ++n4) {
            char c2 = stringArray.charAt(n4);
            n2 = c2;
            if (c2 == ':' || Character.isWhitespace((char)n2)) break;
        }
        for (n2 = n4; n2 < stringArray.length(); ++n2) {
            if (stringArray.charAt(n2) != ':') continue;
            ++n2;
            break;
        }
        n2 = HttpPostBodyUtil.findNonWhitespace((String)stringArray, n2);
        int n5 = HttpPostBodyUtil.findEndOfString((String)stringArray);
        arrayList.add(stringArray.substring(n3, n4));
        String string2 = stringArray.substring(n2, n5);
        for (String string2 : string2.indexOf(59) >= 0 ? HttpPostMultipartRequestDecoder.splitMultipartHeaderValues(string2) : string2.split(",")) {
            arrayList.add(string2.trim());
        }
        stringArray = new String[arrayList.size()];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            stringArray[n3] = (String)arrayList.get(n3);
        }
        return stringArray;
    }

    private static String[] splitMultipartHeaderValues(String string) {
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList(1);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl) {
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (c2 == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c2 != '\"') continue;
                bl = false;
                continue;
            }
            if (c2 == '\"') {
                bl = true;
                continue;
            }
            if (c2 != ';') continue;
            arrayList.add(string.substring(n2, i2));
            n2 = i2 + 1;
        }
        arrayList.add(string.substring(n2));
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }
}

