/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.List;

public class HttpPostRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    static final int DEFAULT_DISCARD_THRESHOLD = 0xA00000;
    private final InterfaceHttpPostRequestDecoder decoder;

    public HttpPostRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        if (httpDataFactory == null) {
            throw new NullPointerException("factory");
        }
        if (httpRequest == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (HttpPostRequestDecoder.isMultipart(httpRequest)) {
            this.decoder = new HttpPostMultipartRequestDecoder(httpDataFactory, httpRequest, charset);
            return;
        }
        this.decoder = new HttpPostStandardRequestDecoder(httpDataFactory, httpRequest, charset);
    }

    public static boolean isMultipart(HttpRequest httpRequest) {
        if (httpRequest.headers().contains("Content-Type")) {
            return HttpPostRequestDecoder.getMultipartDataBoundary(httpRequest.headers().get("Content-Type")) != null;
        }
        return false;
    }

    protected static String[] getMultipartDataBoundary(String stringArray) {
        if ((stringArray = HttpPostRequestDecoder.splitHeaderContentType((String)stringArray))[0].toLowerCase().startsWith("multipart/form-data")) {
            int n2;
            String string;
            int n3;
            int n4;
            if (stringArray[1].toLowerCase().startsWith("boundary")) {
                n4 = 1;
                n3 = 2;
            } else if (stringArray[2].toLowerCase().startsWith("boundary")) {
                n4 = 2;
                n3 = 1;
            } else {
                return null;
            }
            String string2 = StringUtil.substringAfter(stringArray[n4], '=');
            if (string2 == null) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Needs a boundary value");
            }
            if (string2.charAt(0) == '\"' && (string = string2.trim()).charAt(n2 = string.length() - 1) == '\"') {
                string2 = string.substring(1, n2);
            }
            if (stringArray[n3].toLowerCase().startsWith("charset") && (string = StringUtil.substringAfter(stringArray[n3], '=')) != null) {
                return new String[]{"--" + string2, string};
            }
            return new String[]{"--" + string2};
        }
        return null;
    }

    @Override
    public boolean isMultipart() {
        return this.decoder.isMultipart();
    }

    @Override
    public void setDiscardThreshold(int n2) {
        this.decoder.setDiscardThreshold(n2);
    }

    @Override
    public int getDiscardThreshold() {
        return this.decoder.getDiscardThreshold();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        return this.decoder.getBodyHttpDatas();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        return this.decoder.getBodyHttpDatas(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        return this.decoder.getBodyHttpData(string);
    }

    @Override
    public InterfaceHttpPostRequestDecoder offer(HttpContent httpContent) {
        return this.decoder.offer(httpContent);
    }

    @Override
    public boolean hasNext() {
        return this.decoder.hasNext();
    }

    @Override
    public InterfaceHttpData next() {
        return this.decoder.next();
    }

    @Override
    public void destroy() {
        this.decoder.destroy();
    }

    @Override
    public void cleanFiles() {
        this.decoder.cleanFiles();
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.decoder.removeHttpDataFromClean(interfaceHttpData);
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (this.decoder instanceof HttpPostMultipartRequestDecoder) {
            ((HttpPostMultipartRequestDecoder)this.decoder).addHttpData(interfaceHttpData);
            return;
        }
        ((HttpPostStandardRequestDecoder)this.decoder).addHttpData(interfaceHttpData);
    }

    protected InterfaceHttpData getFileUpload(String string) {
        if (this.decoder instanceof HttpPostMultipartRequestDecoder) {
            ((HttpPostMultipartRequestDecoder)this.decoder).getFileUpload(string);
        }
        return null;
    }

    private static String[] splitHeaderContentType(String string) {
        int n2;
        int n3 = HttpPostBodyUtil.findNonWhitespace(string, 0);
        int n4 = string.indexOf(59);
        if (n4 == -1) {
            return new String[]{string, "", ""};
        }
        int n5 = HttpPostBodyUtil.findNonWhitespace(string, n4 + 1);
        if (string.charAt(n4 - 1) == ' ') {
            --n4;
        }
        if ((n2 = string.indexOf(59, n5)) == -1) {
            n2 = HttpPostBodyUtil.findEndOfString(string);
            return new String[]{string.substring(n3, n4), string.substring(n5, n2), ""};
        }
        int n6 = HttpPostBodyUtil.findNonWhitespace(string, n2 + 1);
        if (string.charAt(n2 - 1) == ' ') {
            --n2;
        }
        int n7 = HttpPostBodyUtil.findEndOfString(string);
        return new String[]{string.substring(n3, n4), string.substring(n5, n2), string.substring(n6, n7)};
    }
}

