/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.Attribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.FileUpload;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$TransferEncodingMechanism;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$EncoderMode;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$ErrorDataEncoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$WrappedFullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$WrappedHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InternalAttribute;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedInput;
import com.aliyun.openservices.shade.io.netty.util.internal.ThreadLocalRandom;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class HttpPostRequestEncoder
implements ChunkedInput<HttpContent> {
    private static final Map<Pattern, String> percentEncodings = new HashMap<Pattern, String>();
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isChunked;
    private final List<InterfaceHttpData> bodyListDatas;
    final List<InterfaceHttpData> multipartHttpDatas;
    private final boolean isMultipart;
    String multipartDataBoundary;
    String multipartMixedBoundary;
    private boolean headerFinalized;
    private final HttpPostRequestEncoder$EncoderMode encoderMode;
    private boolean isLastChunk;
    private boolean isLastChunkSent;
    private FileUpload currentFileUpload;
    private boolean duringMixedMode;
    private long globalBodySize;
    private ListIterator<InterfaceHttpData> iterator;
    private ByteBuf currentBuffer;
    private InterfaceHttpData currentData;
    private boolean isKey = true;

    public HttpPostRequestEncoder(HttpRequest httpRequest, boolean bl) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, bl, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder$EncoderMode.RFC1738);
    }

    public HttpPostRequestEncoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, boolean bl) {
        this(httpDataFactory, httpRequest, bl, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder$EncoderMode.RFC1738);
    }

    public HttpPostRequestEncoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, boolean bl, Charset charset, HttpPostRequestEncoder$EncoderMode httpPostRequestEncoder$EncoderMode) {
        if (httpDataFactory == null) {
            throw new NullPointerException("factory");
        }
        if (httpRequest == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (httpRequest.getMethod() != HttpMethod.POST) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException("Cannot create a Encoder if not a POST");
        }
        this.request = httpRequest;
        this.charset = charset;
        this.factory = httpDataFactory;
        this.bodyListDatas = new ArrayList<InterfaceHttpData>();
        this.isLastChunk = false;
        this.isLastChunkSent = false;
        this.isMultipart = bl;
        this.multipartHttpDatas = new ArrayList<InterfaceHttpData>();
        this.encoderMode = httpPostRequestEncoder$EncoderMode;
        if (this.isMultipart) {
            this.initDataMultipart();
        }
    }

    public void cleanFiles() {
        this.factory.cleanRequestHttpDatas(this.request);
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private void initDataMultipart() {
        this.multipartDataBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private void initMixedMultipart() {
        this.multipartMixedBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private static String getNewMultipartDelimiter() {
        return Long.toHexString(ThreadLocalRandom.current().nextLong()).toLowerCase();
    }

    public List<InterfaceHttpData> getBodyListAttributes() {
        return this.bodyListDatas;
    }

    public void setBodyHttpDatas(List<InterfaceHttpData> object) {
        if (object == null) {
            throw new NullPointerException("datas");
        }
        this.globalBodySize = 0L;
        this.bodyListDatas.clear();
        this.currentFileUpload = null;
        this.duringMixedMode = false;
        this.multipartHttpDatas.clear();
        object = object.iterator();
        while (object.hasNext()) {
            InterfaceHttpData interfaceHttpData = (InterfaceHttpData)object.next();
            this.addBodyHttpData(interfaceHttpData);
        }
    }

    public void addBodyAttribute(String object, String string) {
        if (object == null) {
            throw new NullPointerException("name");
        }
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        object = this.factory.createAttribute(this.request, (String)object, string2);
        this.addBodyHttpData((InterfaceHttpData)object);
    }

    public void addBodyFileUpload(String object, File file, String string, boolean bl) {
        if (object == null) {
            throw new NullPointerException("name");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        String string2 = string;
        String string3 = null;
        if (string == null) {
            string2 = bl ? "text/plain" : "application/octet-stream";
        }
        if (!bl) {
            string3 = HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value();
        }
        object = this.factory.createFileUpload(this.request, (String)object, file.getName(), string2, string3, null, file.length());
        try {
            object.setContent(file);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
        }
        this.addBodyHttpData((InterfaceHttpData)object);
    }

    public void addBodyFileUploads(String string, File[] fileArray, String[] stringArray, boolean[] blArray) {
        if (fileArray.length != stringArray.length && fileArray.length != blArray.length) {
            throw new NullPointerException("Different array length");
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            this.addBodyFileUpload(string, fileArray[i2], stringArray[i2], blArray[i2]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addBodyHttpData(InterfaceHttpData var1_1) {
        block21: {
            block24: {
                block22: {
                    block23: {
                        if (this.headerFinalized) {
                            throw new HttpPostRequestEncoder$ErrorDataEncoderException("Cannot add value once finalized");
                        }
                        if (var1_1 == null) {
                            throw new NullPointerException("data");
                        }
                        this.bodyListDatas.add(var1_1);
                        if (!this.isMultipart) {
                            if (var1_1 instanceof Attribute) {
                                var2_2 = (Attribute)var1_1;
                                try {
                                    var3_6 = this.encodeAttribute(var2_2.getName(), this.charset);
                                    var4_11 = this.encodeAttribute(var2_2.getValue(), this.charset);
                                    var4_11 = this.factory.createAttribute(this.request, var3_6, (String)var4_11);
                                    this.multipartHttpDatas.add((InterfaceHttpData)var4_11);
                                    this.globalBodySize += (long)(var4_11.getName().length() + 1) + var4_11.length() + 1L;
                                }
                                catch (IOException var3_7) {
                                    throw new HttpPostRequestEncoder$ErrorDataEncoderException(var3_7);
                                }
                            } else if (var1_1 instanceof FileUpload) {
                                var2_3 = (FileUpload)var1_1;
                                var3_8 = this.encodeAttribute(var2_3.getName(), this.charset);
                                var4_12 = this.encodeAttribute(var2_3.getFilename(), this.charset);
                                var4_12 = this.factory.createAttribute(this.request, var3_8, (String)var4_12);
                                this.multipartHttpDatas.add((InterfaceHttpData)var4_12);
                                this.globalBodySize += (long)(var4_12.getName().length() + 1) + var4_12.length() + 1L;
                            }
                            return;
                        }
                        if (var1_1 instanceof Attribute) {
                            if (this.duringMixedMode) {
                                var2_4 = new InternalAttribute(this.charset);
                                var2_4.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                                this.multipartHttpDatas.add(var2_4);
                                this.multipartMixedBoundary = null;
                                this.currentFileUpload = null;
                                this.duringMixedMode = false;
                            }
                            var2_4 = new InternalAttribute(this.charset);
                            if (!this.multipartHttpDatas.isEmpty()) {
                                var2_4.addValue("\r\n");
                            }
                            var2_4.addValue("--" + this.multipartDataBoundary + "\r\n");
                            var3_9 = (Attribute)var1_1;
                            var2_4.addValue("Content-Disposition: form-data; name=\"" + var3_9.getName() + "\"\r\n");
                            var4_13 = var3_9.getCharset();
                            if (var4_13 != null) {
                                var2_4.addValue("Content-Type: text/plain; charset=" + var4_13.name() + "\r\n");
                            }
                            var2_4.addValue("\r\n");
                            this.multipartHttpDatas.add(var2_4);
                            this.multipartHttpDatas.add(var1_1);
                            this.globalBodySize += var3_9.length() + (long)var2_4.size();
                            return;
                        }
                        if (!(var1_1 instanceof FileUpload)) break block21;
                        var2_5 = (FileUpload)var1_1;
                        var3_10 = new InternalAttribute(this.charset);
                        if (!this.multipartHttpDatas.isEmpty()) {
                            var3_10.addValue("\r\n");
                        }
                        if (!this.duringMixedMode) break block22;
                        if (this.currentFileUpload == null || !this.currentFileUpload.getName().equals(var2_5.getName())) break block23;
                        var4_14 = true;
                        break block24;
                    }
                    var3_10.addValue("--" + this.multipartMixedBoundary + "--");
                    this.multipartHttpDatas.add(var3_10);
                    this.multipartMixedBoundary = null;
                    var3_10 = new InternalAttribute(this.charset);
                    var3_10.addValue("\r\n");
                    ** GOTO lbl-1000
                }
                if (this.currentFileUpload != null && this.currentFileUpload.getName().equals(var2_5.getName())) {
                    this.initMixedMultipart();
                    var4_15 = (InternalAttribute)this.multipartHttpDatas.get(this.multipartHttpDatas.size() - 2);
                    this.globalBodySize -= (long)var4_15.size();
                    var5_17 = new StringBuilder(139 + this.multipartDataBoundary.length() + (this.multipartMixedBoundary.length() << 1) + var2_5.getFilename().length() + var2_5.getName().length());
                    var5_17.append("--").append(this.multipartDataBoundary).append("\r\nContent-Disposition").append(": form-data").append("; name").append("=\"").append(var2_5.getName()).append("\"\r\nContent-Type").append(": multipart/mixed").append("; boundary").append('=').append(this.multipartMixedBoundary).append("\r\n\r\n--").append(this.multipartMixedBoundary).append("\r\nContent-Disposition").append(": attachment").append("; filename").append("=\"").append(var2_5.getFilename()).append("\"\r\n");
                    var4_15.setValue(var5_17.toString(), 1);
                    var4_15.setValue("", 2);
                    this.globalBodySize += (long)var4_15.size();
                    var4_14 = true;
                    this.duringMixedMode = true;
                } else lbl-1000:
                // 2 sources

                {
                    var4_14 = false;
                    this.currentFileUpload = var2_5;
                    this.duringMixedMode = false;
                }
            }
            if (var4_14) {
                var3_10.addValue("--" + this.multipartMixedBoundary + "\r\n");
                var3_10.addValue("Content-Disposition: attachment; filename=\"" + var2_5.getFilename() + "\"\r\n");
            } else {
                var3_10.addValue("--" + this.multipartDataBoundary + "\r\n");
                var3_10.addValue("Content-Disposition: form-data; name=\"" + var2_5.getName() + "\"; filename" + "=\"" + var2_5.getFilename() + "\"\r\n");
            }
            var3_10.addValue("Content-Type: " + var2_5.getContentType());
            var4_16 = var2_5.getContentTransferEncoding();
            if (var4_16 != null && var4_16.equals(HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value())) {
                var3_10.addValue("\r\nContent-Transfer-Encoding: " + HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value() + "\r\n\r\n");
            } else if (var2_5.getCharset() != null) {
                var3_10.addValue("; charset=" + var2_5.getCharset().name() + "\r\n\r\n");
            } else {
                var3_10.addValue("\r\n\r\n");
            }
            this.multipartHttpDatas.add(var3_10);
            this.multipartHttpDatas.add(var1_1);
            this.globalBodySize += var2_5.length() + (long)var3_10.size();
        }
    }

    public HttpRequest finalizeRequest() {
        Object object;
        Object object2;
        if (!this.headerFinalized) {
            if (this.isMultipart) {
                object2 = new InternalAttribute(this.charset);
                if (this.duringMixedMode) {
                    ((InternalAttribute)object2).addValue("\r\n--" + this.multipartMixedBoundary + "--");
                }
                ((InternalAttribute)object2).addValue("\r\n--" + this.multipartDataBoundary + "--\r\n");
                this.multipartHttpDatas.add((InterfaceHttpData)object2);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
                this.globalBodySize += (long)((InternalAttribute)object2).size();
            }
        } else {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException("Header already encoded");
        }
        this.headerFinalized = true;
        object2 = this.request.headers();
        List<String> object32 = ((HttpHeaders)object2).getAll("Content-Type");
        List<String> list = ((HttpHeaders)object2).getAll("Transfer-Encoding");
        if (object32 != null) {
            ((HttpHeaders)object2).remove("Content-Type");
            for (String string : object32) {
                object = string.toLowerCase();
                if (((String)object).startsWith("multipart/form-data") || ((String)object).startsWith("application/x-www-form-urlencoded")) continue;
                ((HttpHeaders)object2).add("Content-Type", (Object)string);
            }
        }
        if (this.isMultipart) {
            String string = "multipart/form-data; boundary=" + this.multipartDataBoundary;
            ((HttpHeaders)object2).add("Content-Type", (Object)string);
        } else {
            ((HttpHeaders)object2).add("Content-Type", (Object)"application/x-www-form-urlencoded");
        }
        long l2 = this.globalBodySize;
        if (this.isMultipart) {
            this.iterator = this.multipartHttpDatas.listIterator();
        } else {
            --l2;
            this.iterator = this.multipartHttpDatas.listIterator();
        }
        ((HttpHeaders)object2).set("Content-Length", (Object)String.valueOf(l2));
        if (l2 > 8096L || this.isMultipart) {
            this.isChunked = true;
            if (list != null) {
                ((HttpHeaders)object2).remove("Transfer-Encoding");
                for (String string : list) {
                    if (string.equalsIgnoreCase("chunked")) continue;
                    ((HttpHeaders)object2).add("Transfer-Encoding", (Object)string);
                }
            }
            HttpHeaders.setTransferEncodingChunked(this.request);
            return new HttpPostRequestEncoder$WrappedHttpRequest(this.request);
        }
        object = this.nextChunk();
        if (this.request instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)this.request;
            object2 = object.content();
            if (fullHttpRequest.content() != object2) {
                fullHttpRequest.content().clear().writeBytes((ByteBuf)object2);
                object2.release();
            }
            return fullHttpRequest;
        }
        return new HttpPostRequestEncoder$WrappedFullHttpRequest(this.request, (HttpContent)object, null);
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    private String encodeAttribute(String string, Charset charset) {
        if (string == null) {
            return "";
        }
        try {
            string = URLEncoder.encode(string, charset.name());
            if (this.encoderMode == HttpPostRequestEncoder$EncoderMode.RFC3986) {
                for (Map.Entry<Pattern, String> entry : percentEncodings.entrySet()) {
                    String string2 = entry.getValue();
                    string = entry.getKey().matcher(string).replaceAll(string2);
                }
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException(charset.name(), unsupportedEncodingException);
        }
    }

    private ByteBuf fillByteBuf() {
        int n2 = this.currentBuffer.readableBytes();
        if (n2 > 8096) {
            ByteBuf byteBuf = this.currentBuffer.slice(this.currentBuffer.readerIndex(), 8096);
            this.currentBuffer.retain();
            this.currentBuffer.skipBytes(8096);
            return byteBuf;
        }
        ByteBuf byteBuf = this.currentBuffer;
        this.currentBuffer = null;
        return byteBuf;
    }

    private HttpContent encodeNextChunkMultipart(int n2) {
        ByteBuf byteBuf;
        if (this.currentData == null) {
            return null;
        }
        if (this.currentData instanceof InternalAttribute) {
            byteBuf = ((InternalAttribute)this.currentData).toByteBuf();
            this.currentData = null;
        } else {
            if (this.currentData instanceof Attribute) {
                try {
                    byteBuf = ((Attribute)this.currentData).getChunk(n2);
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
                }
            }
            try {
                byteBuf = ((HttpData)this.currentData).getChunk(n2);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
            }
            if (byteBuf.capacity() == 0) {
                this.currentData = null;
                return null;
            }
        }
        this.currentBuffer = this.currentBuffer == null ? byteBuf : Unpooled.wrappedBuffer(this.currentBuffer, byteBuf);
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            return null;
        }
        byteBuf = this.fillByteBuf();
        return new DefaultHttpContent(byteBuf);
    }

    private HttpContent encodeNextChunkUrlEncoded(int n2) {
        ByteBuf byteBuf;
        String string;
        if (this.currentData == null) {
            return null;
        }
        int n3 = n2;
        if (this.isKey) {
            string = this.currentData.getName();
            byteBuf = Unpooled.wrappedBuffer(string.getBytes());
            this.isKey = false;
            if (this.currentBuffer == null) {
                this.currentBuffer = Unpooled.wrappedBuffer(byteBuf, Unpooled.wrappedBuffer("=".getBytes()));
                n3 = n2 - (byteBuf.readableBytes() + 1);
            } else {
                this.currentBuffer = Unpooled.wrappedBuffer(this.currentBuffer, byteBuf, Unpooled.wrappedBuffer("=".getBytes()));
                n3 = n2 - (byteBuf.readableBytes() + 1);
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                byteBuf = this.fillByteBuf();
                return new DefaultHttpContent(byteBuf);
            }
        }
        try {
            byteBuf = ((HttpData)this.currentData).getChunk(n3);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
        }
        string = null;
        if (byteBuf.readableBytes() < n3) {
            this.isKey = true;
            String string2 = string = this.iterator.hasNext() ? Unpooled.wrappedBuffer("&".getBytes()) : null;
        }
        if (byteBuf.capacity() == 0) {
            this.currentData = null;
            if (this.currentBuffer == null) {
                this.currentBuffer = string;
            } else if (string != null) {
                this.currentBuffer = Unpooled.wrappedBuffer(new ByteBuf[]{this.currentBuffer, string});
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                byteBuf = this.fillByteBuf();
                return new DefaultHttpContent(byteBuf);
            }
            return null;
        }
        this.currentBuffer = this.currentBuffer == null ? (string != null ? Unpooled.wrappedBuffer(new ByteBuf[]{byteBuf, string}) : byteBuf) : (string != null ? Unpooled.wrappedBuffer(new ByteBuf[]{this.currentBuffer, byteBuf, string}) : Unpooled.wrappedBuffer(this.currentBuffer, byteBuf));
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            this.isKey = true;
            return null;
        }
        byteBuf = this.fillByteBuf();
        return new DefaultHttpContent(byteBuf);
    }

    @Override
    public void close() {
    }

    @Override
    public HttpContent readChunk(ChannelHandlerContext channelHandlerContext) {
        if (this.isLastChunkSent) {
            return null;
        }
        return this.nextChunk();
    }

    private HttpContent nextChunk() {
        if (this.isLastChunk) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        int n2 = 8096;
        if (this.currentBuffer != null) {
            n2 = 8096 - this.currentBuffer.readableBytes();
        }
        if (n2 <= 0) {
            ByteBuf byteBuf = this.fillByteBuf();
            return new DefaultHttpContent(byteBuf);
        }
        if (this.currentData != null) {
            HttpContent httpContent;
            if (this.isMultipart ? (httpContent = this.encodeNextChunkMultipart(n2)) != null : (httpContent = this.encodeNextChunkUrlEncoded(n2)) != null) {
                return httpContent;
            }
            n2 = 8096 - this.currentBuffer.readableBytes();
        }
        if (!this.iterator.hasNext()) {
            this.isLastChunk = true;
            ByteBuf byteBuf = this.currentBuffer;
            this.currentBuffer = null;
            return new DefaultHttpContent(byteBuf);
        }
        while (n2 > 0 && this.iterator.hasNext()) {
            this.currentData = this.iterator.next();
            HttpContent httpContent = this.isMultipart ? this.encodeNextChunkMultipart(n2) : this.encodeNextChunkUrlEncoded(n2);
            if (httpContent == null) {
                n2 = 8096 - this.currentBuffer.readableBytes();
                continue;
            }
            return httpContent;
        }
        this.isLastChunk = true;
        if (this.currentBuffer == null) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        ByteBuf byteBuf = this.currentBuffer;
        this.currentBuffer = null;
        return new DefaultHttpContent(byteBuf);
    }

    @Override
    public boolean isEndOfInput() {
        return this.isLastChunkSent;
    }

    static {
        percentEncodings.put(Pattern.compile("\\*"), "%2A");
        percentEncodings.put(Pattern.compile("\\+"), "%20");
        percentEncodings.put(Pattern.compile("%7E"), "~");
    }
}

