/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpConstants;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.QueryStringDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.Attribute;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpDataFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadNoBackArrayException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadOptimize;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$EndOfDataDecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$MultiPartStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$NotEnoughDataDecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostStandardRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private HttpPostRequestDecoder$MultiPartStatus currentStatus = HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    public HttpPostStandardRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        if (httpDataFactory == null) {
            throw new NullPointerException("factory");
        }
        if (httpRequest == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.request = httpRequest;
        this.charset = charset;
        this.factory = httpDataFactory;
        if (httpRequest instanceof HttpContent) {
            this.offer((HttpContent)((Object)httpRequest));
            return;
        }
        this.undecodedChunk = Unpooled.buffer();
        this.parseBody();
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostStandardRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return false;
    }

    @Override
    public void setDiscardThreshold(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("discardThreshold must be >= 0");
        }
        this.discardThreshold = n2;
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String object) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        if ((object = this.bodyMapHttpData.get(object)) != null) {
            return (InterfaceHttpData)object.get(0);
        }
        return null;
    }

    @Override
    public HttpPostStandardRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        ByteBuf byteBuf = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = byteBuf.copy();
        } else {
            this.undecodedChunk.writeBytes(byteBuf);
        }
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            this.undecodedChunk.discardReadBytes();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder$EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyAttributes();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributesStandard() {
        int n2;
        int n3 = n2 = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
        }
        int n4 = 1;
        try {
            block7: while (this.undecodedChunk.isReadable() && n4 != 0) {
                int n5 = this.undecodedChunk.readUnsignedByte();
                ++n3;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        if (n5 == 61) {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
                            n5 = n3 - 1;
                            String string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n5 - n2, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            n2 = n3;
                            continue block7;
                        }
                        if (n5 != 38) continue block7;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                        n4 = n3 - 1;
                        String string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n4 - n2, this.charset), this.charset);
                        this.currentAttribute = this.factory.createAttribute(this.request, string);
                        this.currentAttribute.setValue("");
                        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                        httpPostStandardRequestDecoder.addHttpData(httpPostStandardRequestDecoder.currentAttribute);
                        this.currentAttribute = null;
                        n2 = n3;
                        n4 = 1;
                        continue block7;
                    }
                    case FIELD: {
                        if (n5 == 38) {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                            n4 = n3 - 1;
                            HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                            httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                            n2 = n3;
                            n4 = 1;
                            continue block7;
                        }
                        if (n5 == 13) {
                            if (this.undecodedChunk.isReadable()) {
                                n5 = (char)this.undecodedChunk.readUnsignedByte();
                                if (n5 != 10) throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad end of line");
                                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                                n4 = ++n3 - 2;
                                HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                                httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                                n2 = n3;
                                break;
                            }
                            --n3;
                            continue block7;
                        }
                        if (n5 != 10) continue block7;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                        n4 = n3 - 1;
                        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                        httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                        n2 = n3;
                        break;
                    }
                }
                n4 = 0;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                n4 = n3;
                if (n4 > n2) {
                    HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                    httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                n2 = n3;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
                this.undecodedChunk.readerIndex(n2);
                return;
            }
            if (n4 != 0 && this.currentAttribute != null) {
                if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FIELD) {
                    this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n3 - n2), false);
                    n2 = n3;
                }
                this.undecodedChunk.readerIndex(n2);
                return;
            }
            this.undecodedChunk.readerIndex(n2);
            return;
        }
        catch (HttpPostRequestDecoder$ErrorDataDecoderException httpPostRequestDecoder$ErrorDataDecoderException) {
            this.undecodedChunk.readerIndex(n2);
            throw httpPostRequestDecoder$ErrorDataDecoderException;
        }
        catch (IOException iOException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributes() {
        int n2;
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize;
        try {
            httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil$SeekAheadNoBackArrayException httpPostBodyUtil$SeekAheadNoBackArrayException) {
            this.parseBodyAttributesStandard();
            return;
        }
        int n3 = n2 = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
        }
        int n4 = 1;
        try {
            block10: while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                int n5 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF;
                ++n3;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        if (n5 == 61) {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
                            n5 = n3 - 1;
                            String string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n5 - n2, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            n2 = n3;
                            continue block10;
                        }
                        if (n5 != 38) continue block10;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                        n4 = n3 - 1;
                        String string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n4 - n2, this.charset), this.charset);
                        this.currentAttribute = this.factory.createAttribute(this.request, string);
                        this.currentAttribute.setValue("");
                        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                        httpPostStandardRequestDecoder.addHttpData(httpPostStandardRequestDecoder.currentAttribute);
                        this.currentAttribute = null;
                        n2 = n3;
                        n4 = 1;
                        continue block10;
                    }
                    case FIELD: {
                        if (n5 == 38) {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                            n4 = n3 - 1;
                            HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                            httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                            n2 = n3;
                            n4 = 1;
                            continue block10;
                        }
                        if (n5 == 13) {
                            if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                                n5 = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF);
                                ++n3;
                                if (n5 != 10) {
                                    httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                    throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad end of line");
                                }
                                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                                n4 = n3 - 2;
                                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                                httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                                n2 = n3;
                                n4 = 0;
                                break block10;
                            }
                            if (httpPostBodyUtil$SeekAheadOptimize.limit <= 0) continue block10;
                            --n3;
                            continue block10;
                        }
                        if (n5 != 10) continue block10;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                        n4 = n3 - 1;
                        httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                        httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                        n2 = n3;
                        n4 = 0;
                        break block10;
                    }
                }
                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                n4 = 0;
                break;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                n4 = n3;
                if (n4 > n2) {
                    HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                    httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.copy(n2, n4 - n2));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                n2 = n3;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
                this.undecodedChunk.readerIndex(n2);
                return;
            }
            if (n4 != 0 && this.currentAttribute != null) {
                if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FIELD) {
                    this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n3 - n2), false);
                    n2 = n3;
                }
                this.undecodedChunk.readerIndex(n2);
                return;
            }
            this.undecodedChunk.readerIndex(n2);
            return;
        }
        catch (HttpPostRequestDecoder$ErrorDataDecoderException httpPostRequestDecoder$ErrorDataDecoderException) {
            this.undecodedChunk.readerIndex(n2);
            throw httpPostRequestDecoder$ErrorDataDecoderException;
        }
        catch (IOException iOException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
        }
    }

    private void setFinalBuffer(ByteBuf object) {
        this.currentAttribute.addContent((ByteBuf)object, true);
        object = HttpPostStandardRequestDecoder.decodeAttribute(this.currentAttribute.getByteBuf().toString(this.charset), this.charset);
        this.currentAttribute.setValue((String)object);
        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
        httpPostStandardRequestDecoder.addHttpData(httpPostStandardRequestDecoder.currentAttribute);
        this.currentAttribute = null;
    }

    private static String decodeAttribute(String string, Charset charset) {
        try {
            return QueryStringDecoder.decodeComponent(string, charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad string: '" + string + '\'', illegalArgumentException);
        }
    }

    void skipControlCharacters() {
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize;
        try {
            httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil$SeekAheadNoBackArrayException httpPostBodyUtil$SeekAheadNoBackArrayException) {
            try {
                this.skipControlCharactersStandard();
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
            }
        }
        while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
            char c2;
            if (Character.isISOControl(c2 = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF)) || Character.isWhitespace(c2)) continue;
            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(1);
            return;
        }
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException("Access out of bounds");
    }

    void skipControlCharactersStandard() {
        char c2;
        while (Character.isISOControl(c2 = (char)this.undecodedChunk.readUnsignedByte()) || Character.isWhitespace(c2)) {
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
    }

    @Override
    public void destroy() {
        this.checkDestroyed();
        this.cleanFiles();
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
        for (int i2 = this.bodyListHttpDataRank; i2 < this.bodyListHttpData.size(); ++i2) {
            this.bodyListHttpData.get(i2).release();
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpDatas(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }
}

