/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ReplayingDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import java.util.List;

public class WebSocket00FrameDecoder
extends ReplayingDecoder<Void>
implements WebSocketFrameDecoder {
    static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384);
    }

    public WebSocket00FrameDecoder(int n2) {
        this.maxFrameSize = n2;
    }

    @Override
    public void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        byte by = byteBuf.readByte();
        object = (by & 0x80) == 128 ? this.decodeBinaryFrame((ChannelHandlerContext)object, by, byteBuf) : this.decodeTextFrame((ChannelHandlerContext)object, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    private WebSocketFrame decodeBinaryFrame(ChannelHandlerContext object, byte by, ByteBuf byteBuf) {
        byte by2;
        long l2 = 0L;
        int n2 = 0;
        do {
            by2 = byteBuf.readByte();
            l2 <<= 7;
            if ((l2 |= (long)(by2 & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++n2 <= 8) continue;
            throw new TooLongFrameException();
        } while ((by2 & 0x80) == 128);
        if (by == -1 && l2 == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame();
        }
        object = object.alloc().buffer((int)l2);
        byteBuf.readBytes((ByteBuf)object);
        return new BinaryWebSocketFrame((ByteBuf)object);
    }

    private WebSocketFrame decodeTextFrame(ChannelHandlerContext object, ByteBuf byteBuf) {
        int n2 = byteBuf.readerIndex();
        int n3 = this.actualReadableBytes();
        int n4 = n2;
        int n5 = byteBuf.indexOf(n4, n4 + n3, (byte)-1);
        if (n5 == -1) {
            if ((long)n3 > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        if ((long)(n2 = n5 - n2) > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        object = object.alloc().buffer(n2);
        byteBuf.readBytes((ByteBuf)object);
        byteBuf.skipBytes(1);
        Object object2 = object;
        int n6 = ((ByteBuf)object2).indexOf(((ByteBuf)object2).readerIndex(), ((ByteBuf)object).writerIndex(), (byte)-1);
        if (n6 >= 0) {
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame((ByteBuf)object);
    }
}

