/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.CorruptedFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.ReplayingDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.Utf8Validator;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder$State;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameDecoder
extends ReplayingDecoder<WebSocket08FrameDecoder$State>
implements WebSocketFrameDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameDecoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private int fragmentedFramesCount;
    private final long maxFramePayloadLength;
    private boolean frameFinalFlag;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private ByteBuf framePayload;
    private int framePayloadBytesRead;
    private byte[] maskingKey;
    private ByteBuf payloadBuffer;
    private final boolean allowExtensions;
    private final boolean maskedPayload;
    private boolean receivedClosingHandshake;
    private Utf8Validator utf8Validator;

    public WebSocket08FrameDecoder(boolean bl, boolean bl2, int n2) {
        super(WebSocket08FrameDecoder$State.FRAME_START);
        this.maskedPayload = bl;
        this.allowExtensions = bl2;
        this.maxFramePayloadLength = n2;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        try {
            switch ((WebSocket08FrameDecoder$State)((Object)this.state())) {
                case FRAME_START: {
                    this.framePayloadBytesRead = 0;
                    this.framePayloadLength = -1L;
                    this.framePayload = null;
                    this.payloadBuffer = null;
                    int n2 = byteBuf.readByte();
                    this.frameFinalFlag = (n2 & 0x80) != 0;
                    this.frameRsv = (n2 & 0x70) >> 4;
                    this.frameOpcode = n2 & 0xF;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Decoding WebSocket Frame opCode={}", (Object)this.frameOpcode);
                    }
                    byte by = byteBuf.readByte();
                    n2 = by;
                    boolean bl = (by & 0x80) != 0;
                    n2 &= 0x7F;
                    if (this.frameRsv != 0 && !this.allowExtensions) {
                        this.protocolViolation(channelHandlerContext, "RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
                        return;
                    }
                    if (this.maskedPayload && !bl) {
                        this.protocolViolation(channelHandlerContext, "unmasked client to server frame");
                        return;
                    }
                    if (this.frameOpcode > 7) {
                        if (!this.frameFinalFlag) {
                            this.protocolViolation(channelHandlerContext, "fragmented control frame");
                            return;
                        }
                        if (n2 > 125) {
                            this.protocolViolation(channelHandlerContext, "control frame with payload length > 125 octets");
                            return;
                        }
                        if (this.frameOpcode != 8 && this.frameOpcode != 9 && this.frameOpcode != 10) {
                            this.protocolViolation(channelHandlerContext, "control frame using reserved opcode " + this.frameOpcode);
                            return;
                        }
                        if (this.frameOpcode == 8 && n2 == 1) {
                            this.protocolViolation(channelHandlerContext, "received close control frame with payload len 1");
                            return;
                        }
                    } else {
                        if (this.frameOpcode != 0 && this.frameOpcode != 1 && this.frameOpcode != 2) {
                            this.protocolViolation(channelHandlerContext, "data frame using reserved opcode " + this.frameOpcode);
                            return;
                        }
                        if (this.fragmentedFramesCount == 0 && this.frameOpcode == 0) {
                            this.protocolViolation(channelHandlerContext, "received continuation data frame outside fragmented message");
                            return;
                        }
                        if (this.fragmentedFramesCount != 0 && this.frameOpcode != 0 && this.frameOpcode != 9) {
                            this.protocolViolation(channelHandlerContext, "received non-continuation data frame while inside fragmented message");
                            return;
                        }
                    }
                    if (n2 == 126) {
                        this.framePayloadLength = byteBuf.readUnsignedShort();
                        if (this.framePayloadLength < 126L) {
                            this.protocolViolation(channelHandlerContext, "invalid data frame length (not using minimal length encoding)");
                            return;
                        }
                    } else if (n2 == 127) {
                        this.framePayloadLength = byteBuf.readLong();
                        if (this.framePayloadLength < 65536L) {
                            this.protocolViolation(channelHandlerContext, "invalid data frame length (not using minimal length encoding)");
                            return;
                        }
                    } else {
                        this.framePayloadLength = n2;
                    }
                    if (this.framePayloadLength > this.maxFramePayloadLength) {
                        this.protocolViolation(channelHandlerContext, "Max frame length of " + this.maxFramePayloadLength + " has been exceeded.");
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Decoding WebSocket Frame length={}", (Object)this.framePayloadLength);
                    }
                    this.checkpoint(WebSocket08FrameDecoder$State.MASKING_KEY);
                }
                case MASKING_KEY: {
                    if (this.maskedPayload) {
                        if (this.maskingKey == null) {
                            this.maskingKey = new byte[4];
                        }
                        byteBuf.readBytes(this.maskingKey);
                    }
                    this.checkpoint(WebSocket08FrameDecoder$State.PAYLOAD);
                }
                case PAYLOAD: {
                    int n2 = this.actualReadableBytes();
                    long l2 = this.framePayloadBytesRead + n2;
                    if (l2 == this.framePayloadLength) {
                        this.payloadBuffer = channelHandlerContext.alloc().buffer(n2);
                        this.payloadBuffer.writeBytes(byteBuf, n2);
                    } else {
                        if (l2 < this.framePayloadLength) {
                            if (this.framePayload == null) {
                                this.framePayload = channelHandlerContext.alloc().buffer(WebSocket08FrameDecoder.toFrameLength(this.framePayloadLength));
                            }
                            this.framePayload.writeBytes(byteBuf, n2);
                            this.framePayloadBytesRead += n2;
                            return;
                        }
                        if (l2 > this.framePayloadLength) {
                            if (this.framePayload == null) {
                                this.framePayload = channelHandlerContext.alloc().buffer(WebSocket08FrameDecoder.toFrameLength(this.framePayloadLength));
                            }
                            this.framePayload.writeBytes(byteBuf, WebSocket08FrameDecoder.toFrameLength(this.framePayloadLength - (long)this.framePayloadBytesRead));
                        }
                    }
                    this.checkpoint(WebSocket08FrameDecoder$State.FRAME_START);
                    if (this.framePayload == null) {
                        this.framePayload = this.payloadBuffer;
                        this.payloadBuffer = null;
                    } else if (this.payloadBuffer != null) {
                        this.framePayload.writeBytes(this.payloadBuffer);
                        this.payloadBuffer.release();
                        this.payloadBuffer = null;
                    }
                    if (this.maskedPayload) {
                        WebSocket08FrameDecoder webSocket08FrameDecoder = this;
                        webSocket08FrameDecoder.unmask(webSocket08FrameDecoder.framePayload);
                    }
                    if (this.frameOpcode == 9) {
                        list.add(new PingWebSocketFrame(this.frameFinalFlag, this.frameRsv, this.framePayload));
                        this.framePayload = null;
                        return;
                    }
                    if (this.frameOpcode == 10) {
                        list.add(new PongWebSocketFrame(this.frameFinalFlag, this.frameRsv, this.framePayload));
                        this.framePayload = null;
                        return;
                    }
                    if (this.frameOpcode == 8) {
                        this.receivedClosingHandshake = true;
                        this.checkCloseFrameBody(channelHandlerContext, this.framePayload);
                        list.add(new CloseWebSocketFrame(this.frameFinalFlag, this.frameRsv, this.framePayload));
                        this.framePayload = null;
                        return;
                    }
                    if (this.frameFinalFlag) {
                        if (this.frameOpcode != 9) {
                            this.fragmentedFramesCount = 0;
                            if (this.frameOpcode == 1 || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                                this.checkUTF8String(channelHandlerContext, this.framePayload);
                                this.utf8Validator.finish();
                            }
                        }
                    } else {
                        if (this.fragmentedFramesCount == 0) {
                            if (this.frameOpcode == 1) {
                                this.checkUTF8String(channelHandlerContext, this.framePayload);
                            }
                        } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                            this.checkUTF8String(channelHandlerContext, this.framePayload);
                        }
                        ++this.fragmentedFramesCount;
                    }
                    if (this.frameOpcode == 1) {
                        list.add(new TextWebSocketFrame(this.frameFinalFlag, this.frameRsv, this.framePayload));
                        this.framePayload = null;
                        return;
                    }
                    if (this.frameOpcode == 2) {
                        list.add(new BinaryWebSocketFrame(this.frameFinalFlag, this.frameRsv, this.framePayload));
                        this.framePayload = null;
                        return;
                    }
                    if (this.frameOpcode == 0) {
                        list.add(new ContinuationWebSocketFrame(this.frameFinalFlag, this.frameRsv, this.framePayload));
                        this.framePayload = null;
                        return;
                    }
                    throw new UnsupportedOperationException("Cannot decode web socket frame with opcode: " + this.frameOpcode);
                }
                case CORRUPT: {
                    byteBuf.readByte();
                    return;
                }
            }
            throw new Error("Shouldn't reach here.");
        }
        catch (Exception exception) {
            if (this.payloadBuffer != null) {
                if (this.payloadBuffer.refCnt() > 0) {
                    this.payloadBuffer.release();
                }
                this.payloadBuffer = null;
            }
            if (this.framePayload != null) {
                if (this.framePayload.refCnt() > 0) {
                    this.framePayload.release();
                }
                this.framePayload = null;
            }
            throw exception;
        }
    }

    private void unmask(ByteBuf byteBuf) {
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.writerIndex();
        ByteOrder byteOrder = byteBuf.order();
        int n4 = (this.maskingKey[0] & 0xFF) << 24 | (this.maskingKey[1] & 0xFF) << 16 | (this.maskingKey[2] & 0xFF) << 8 | this.maskingKey[3] & 0xFF;
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            n4 = Integer.reverseBytes(n4);
        }
        while (n2 + 3 < n3) {
            int n5 = byteBuf.getInt(n2) ^ n4;
            byteBuf.setInt(n2, n5);
            n2 += 4;
        }
        while (n2 < n3) {
            byteBuf.setByte(n2, byteBuf.getByte(n2) ^ this.maskingKey[n2 % 4]);
            ++n2;
        }
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, String string) {
        this.protocolViolation(channelHandlerContext, new CorruptedFrameException(string));
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, CorruptedFrameException corruptedFrameException) {
        this.checkpoint(WebSocket08FrameDecoder$State.CORRUPT);
        if (channelHandlerContext.channel().isActive()) {
            ReferenceCounted referenceCounted = this.receivedClosingHandshake ? Unpooled.EMPTY_BUFFER : new CloseWebSocketFrame(1002, null);
            channelHandlerContext.writeAndFlush(referenceCounted).addListener(ChannelFutureListener.CLOSE);
        }
        throw corruptedFrameException;
    }

    private static int toFrameLength(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new TooLongFrameException("Length:" + l2);
        }
        return (int)l2;
    }

    private void checkUTF8String(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        try {
            if (this.utf8Validator == null) {
                this.utf8Validator = new Utf8Validator();
            }
            this.utf8Validator.check(byteBuf);
            return;
        }
        catch (CorruptedFrameException corruptedFrameException) {
            this.protocolViolation(channelHandlerContext, corruptedFrameException);
            return;
        }
    }

    protected void checkCloseFrameBody(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (byteBuf == null || !byteBuf.isReadable()) {
            return;
        }
        if (byteBuf.readableBytes() == 1) {
            this.protocolViolation(channelHandlerContext, "Invalid close frame body");
        }
        int n2 = byteBuf.readerIndex();
        byteBuf.readerIndex(0);
        short s2 = byteBuf.readShort();
        if (s2 >= 0 && s2 <= 999 || s2 >= 1004 && s2 <= 1006 || s2 >= 1012 && s2 <= 2999) {
            this.protocolViolation(channelHandlerContext, "Invalid close frame getStatus code: " + s2);
        }
        if (byteBuf.isReadable()) {
            try {
                new Utf8Validator().check(byteBuf);
            }
            catch (CorruptedFrameException corruptedFrameException) {
                this.protocolViolation(channelHandlerContext, corruptedFrameException);
            }
        }
        byteBuf.readerIndex(n2);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        super.channelInactive(channelHandlerContext);
        if (this.framePayload != null) {
            this.framePayload.release();
        }
        if (this.payloadBuffer != null) {
            this.payloadBuffer.release();
        }
    }
}

