/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.CombinedChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpClientCodec;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContentDecompressor;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectAggregator;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequestEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$2;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$3;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$4;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.net.URI;
import java.nio.channels.ClosedChannelException;

public abstract class WebSocketClientHandshaker {
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), WebSocketClientHandshaker.class, "processHandshake(...)");
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n2) {
        this.uri = uRI;
        this.version = webSocketVersion;
        this.expectedSubprotocol = string;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n2;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    private void setActualSubprotocol(String string) {
        this.actualSubprotocol = string;
    }

    public ChannelFuture handshake(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        Channel channel2 = channel;
        return this.handshake(channel2, channel2.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, ChannelPromise channelPromise) {
        FullHttpRequest fullHttpRequest = this.newHandshakeRequest();
        ChannelInboundHandlerAdapter channelInboundHandlerAdapter = channel.pipeline().get(HttpResponseDecoder.class);
        if (channelInboundHandlerAdapter == null && (channelInboundHandlerAdapter = channel.pipeline().get(HttpClientCodec.class)) == null) {
            channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain a HttpResponseDecoder or HttpClientCodec"));
            return channelPromise;
        }
        channel.writeAndFlush(fullHttpRequest).addListener(new WebSocketClientHandshaker$1(this, channelPromise));
        return channelPromise;
    }

    protected abstract FullHttpRequest newHandshakeRequest();

    public final void finishHandshake(Channel channel, FullHttpResponse object) {
        ChannelHandlerContext channelHandlerContext;
        HttpObjectAggregator httpObjectAggregator;
        this.verify((FullHttpResponse)object);
        object = object.headers().get("Sec-WebSocket-Protocol");
        object = object != null ? ((String)object).trim() : null;
        String[] stringArray = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean bl = false;
        if (stringArray.isEmpty() && object == null) {
            bl = true;
            WebSocketClientHandshaker webSocketClientHandshaker = this;
            webSocketClientHandshaker.setActualSubprotocol(webSocketClientHandshaker.expectedSubprotocol);
        } else if (!stringArray.isEmpty() && object != null && !((String)object).isEmpty()) {
            for (String object22 : stringArray.split(",")) {
                if (!object22.trim().equals(object)) continue;
                bl = true;
                this.setActualSubprotocol((String)object);
                break;
            }
        }
        if (!bl) {
            throw new WebSocketHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", object, this.expectedSubprotocol));
        }
        this.setHandshakeComplete();
        stringArray = channel.pipeline();
        HttpContentDecompressor httpContentDecompressor = stringArray.get(HttpContentDecompressor.class);
        if (httpContentDecompressor != null) {
            stringArray.remove(httpContentDecompressor);
        }
        if ((httpObjectAggregator = stringArray.get(HttpObjectAggregator.class)) != null) {
            stringArray.remove(httpObjectAggregator);
        }
        if ((channelHandlerContext = stringArray.context(HttpResponseDecoder.class)) == null) {
            ChannelHandlerContext channelHandlerContext2 = stringArray.context(HttpClientCodec.class);
            if (channelHandlerContext2 == null) {
                throw new IllegalStateException("ChannelPipeline does not contain a HttpRequestEncoder or HttpClientCodec");
            }
            object = (HttpClientCodec)channelHandlerContext2.handler();
            ((CombinedChannelDuplexHandler)object).removeOutboundHandler();
            stringArray.addAfter(channelHandlerContext2.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new WebSocketClientHandshaker$2(this, (ChannelPipeline)stringArray, (HttpClientCodec)object));
            return;
        }
        if (stringArray.get(HttpRequestEncoder.class) != null) {
            stringArray.remove(HttpRequestEncoder.class);
        }
        object = channelHandlerContext;
        stringArray.addAfter(object.name(), "ws-decoder", this.newWebsocketDecoder());
        channel.eventLoop().execute(new WebSocketClientHandshaker$3(this, (ChannelPipeline)stringArray, (ChannelHandlerContext)object));
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse) {
        return this.processHandshake(channel, httpResponse, channel.newPromise());
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse, ChannelPromise channelPromise) {
        if (httpResponse instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)httpResponse);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            ChannelPipeline channelPipeline = channel.pipeline();
            ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpResponseDecoder.class);
            if (channelHandlerContext == null && (channelHandlerContext = channelPipeline.context(HttpClientCodec.class)) == null) {
                return channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain a HttpResponseDecoder or HttpClientCodec"));
            }
            String string = "httpAggregator";
            channelPipeline.addAfter(channelHandlerContext.name(), string, new HttpObjectAggregator(8192));
            channelPipeline.addAfter(string, "handshaker", new WebSocketClientHandshaker$4(this, channel, channelPromise));
            try {
                channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpResponse));
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        }
        return channelPromise;
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return channel.writeAndFlush(closeWebSocketFrame, channelPromise);
    }

    static String rawPath(URI object) {
        String string = ((URI)object).getRawPath();
        if ((object = ((URI)object).getQuery()) != null && !((String)object).isEmpty()) {
            string = string + '?' + (String)object;
        }
        if (string == null || string.isEmpty()) {
            return "/";
        }
        return string;
    }

    static int websocketPort(URI uRI) {
        int n2 = uRI.getPort();
        if (n2 == -1) {
            if ("wss".equals(uRI.getScheme())) {
                return 443;
            }
            return 80;
        }
        return n2;
    }

    static CharSequence websocketOriginValue(String string, int n2) {
        string = (n2 == 443 ? "https" : "http") + "://" + string;
        if (n2 != 80 && n2 != 443) {
            return string + ':' + n2;
        }
        return string;
    }

    static /* synthetic */ ClosedChannelException access$000() {
        return CLOSED_CHANNEL_EXCEPTION;
    }
}

