/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.nio.ByteBuffer;

public class WebSocketClientHandshaker00
extends WebSocketClientHandshaker {
    private ByteBuf expectedChallengeResponseBytes;

    public WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n2) {
        super(uRI, webSocketVersion, string, httpHeaders, n2);
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        int n2 = WebSocketUtil.randomNumber(1, 12);
        int n3 = WebSocketUtil.randomNumber(1, 12);
        int n4 = Integer.MAX_VALUE / n2;
        int n5 = Integer.MAX_VALUE / n3;
        n4 = WebSocketUtil.randomNumber(0, n4);
        n5 = WebSocketUtil.randomNumber(0, n5);
        int n6 = n4 * n2;
        int n7 = n5 * n3;
        String string = Integer.toString(n6);
        String string2 = Integer.toString(n7);
        string = WebSocketClientHandshaker00.insertRandomCharacters(string);
        string2 = WebSocketClientHandshaker00.insertRandomCharacters(string2);
        string = WebSocketClientHandshaker00.insertSpaces(string, n2);
        string2 = WebSocketClientHandshaker00.insertSpaces(string2, n3);
        byte[] byArray = WebSocketUtil.randomBytes(8);
        Object object = ByteBuffer.allocate(4);
        ((ByteBuffer)object).putInt(n4);
        Object object2 = ((ByteBuffer)object).array();
        object = ByteBuffer.allocate(4);
        ((ByteBuffer)object).putInt(n5);
        object = ((ByteBuffer)object).array();
        byte[] byArray2 = new byte[16];
        System.arraycopy(object2, 0, byArray2, 0, 4);
        System.arraycopy(object, 0, byArray2, 4, 4);
        System.arraycopy(byArray, 0, byArray2, 8, 8);
        this.expectedChallengeResponseBytes = Unpooled.wrappedBuffer(WebSocketUtil.md5(byArray2));
        object = this.uri();
        object2 = WebSocketClientHandshaker00.rawPath((URI)object);
        int n8 = WebSocketClientHandshaker00.websocketPort((URI)object);
        object = ((URI)object).getHost();
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, (String)object2);
        object2 = defaultFullHttpRequest;
        HttpHeaders httpHeaders = defaultFullHttpRequest.headers();
        httpHeaders.add("Upgrade", (Object)"WebSocket").add("Connection", (Object)"Upgrade").add("Host", object).add("Origin", (Object)WebSocketClientHandshaker00.websocketOriginValue((String)object, n8)).add("Sec-WebSocket-Key1", (Object)string).add("Sec-WebSocket-Key2", (Object)string2);
        object = this.expectedSubprotocol();
        if (object != null && !((String)object).isEmpty()) {
            httpHeaders.add("Sec-WebSocket-Protocol", object);
        }
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
        }
        httpHeaders.set("Content-Length", (Object)byArray.length);
        object2.content().writeBytes(byArray);
        return object2;
    }

    @Override
    protected void verify(FullHttpResponse referenceCounted) {
        Object object = new HttpResponseStatus(101, "WebSocket Protocol Handshake");
        if (!referenceCounted.getStatus().equals(object)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + referenceCounted.getStatus());
        }
        object = referenceCounted.headers();
        String string = ((HttpHeaders)object).get("Upgrade");
        if (!"WebSocket".equalsIgnoreCase(string)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + string);
        }
        if (!((HttpHeaders)object).containsValue("Connection", "Upgrade", true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + ((HttpHeaders)object).get("Connection"));
        }
        if (!((ByteBuf)(referenceCounted = referenceCounted.content())).equals(this.expectedChallengeResponseBytes)) {
            throw new WebSocketHandshakeException("Invalid challenge");
        }
    }

    private static String insertRandomCharacters(String string) {
        int n2;
        int n3 = WebSocketUtil.randomNumber(1, 12);
        char[] cArray = new char[n3];
        int n4 = 0;
        while (n4 < n3) {
            n2 = (int)(Math.random() * 126.0 + 33.0);
            if ((33 >= n2 || n2 >= 47) && (58 >= n2 || n2 >= 126)) continue;
            cArray[n4] = (char)n2;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n4 = WebSocketUtil.randomNumber(0, string.length());
            String string2 = string.substring(0, n4);
            string = string.substring(n4);
            string = string2 + cArray[n2] + string;
        }
        return string;
    }

    private static String insertSpaces(String string, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = WebSocketUtil.randomNumber(1, string.length() - 1);
            String string2 = string.substring(0, n3);
            string = string.substring(n3);
            string = string2 + ' ' + string;
        }
        return string;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket00FrameDecoder(this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket00FrameEncoder();
    }
}

