/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;

public class WebSocketClientHandshaker13
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker13.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;

    public WebSocketClientHandshaker13(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n2) {
        super(uRI, webSocketVersion, string, httpHeaders, n2);
        this.allowExtensions = bl;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        Object object = this.uri();
        Object object2 = WebSocketClientHandshaker13.rawPath((URI)object);
        Object object3 = WebSocketUtil.randomBytes(16);
        object3 = WebSocketUtil.base64(object3);
        Object object4 = (String)object3 + MAGIC_GUID;
        object4 = WebSocketUtil.sha1(((String)object4).getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64((byte[])object4);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 client handshake key: {}, expected response: {}", object3, (Object)this.expectedChallengeResponseString);
        }
        int n2 = WebSocketClientHandshaker13.websocketPort((URI)object);
        object = ((URI)object).getHost();
        object2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, (String)object2);
        HttpHeaders httpHeaders = object2.headers();
        httpHeaders.add("Upgrade", (Object)"WebSocket").add("Connection", (Object)"Upgrade").add("Sec-WebSocket-Key", object3).add("Host", (Object)((String)object + ':' + n2)).add("Sec-WebSocket-Origin", (Object)WebSocketClientHandshaker13.websocketOriginValue((String)object, n2));
        object = this.expectedSubprotocol();
        if (object != null && !((String)object).isEmpty()) {
            httpHeaders.add("Sec-WebSocket-Protocol", object);
        }
        httpHeaders.add("Sec-WebSocket-Version", (Object)"13");
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
        }
        return object2;
    }

    @Override
    protected void verify(FullHttpResponse object) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.SWITCHING_PROTOCOLS;
        HttpHeaders httpHeaders = object.headers();
        if (!object.getStatus().equals(httpResponseStatus)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + object.getStatus());
        }
        object = httpHeaders.get("Upgrade");
        if (!"WebSocket".equalsIgnoreCase((String)object)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + (String)object);
        }
        if (!httpHeaders.containsValue("Connection", "Upgrade", true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + httpHeaders.get("Connection"));
        }
        object = httpHeaders.get("Sec-WebSocket-Accept");
        if (object == null || !((String)object).equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", object, this.expectedChallengeResponseString));
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(true);
    }
}

