/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.List;

public class WebSocketFrameAggregator
extends MessageToMessageDecoder<WebSocketFrame> {
    private final int maxFrameSize;
    private WebSocketFrame currentFrame;
    private boolean tooLongFrameFound;

    public WebSocketFrameAggregator(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxFrameSize must be > 0");
        }
        this.maxFrameSize = n2;
    }

    @Override
    protected void decode(ChannelHandlerContext object, WebSocketFrame webSocketFrame, List<Object> list) {
        if (this.currentFrame == null) {
            this.tooLongFrameFound = false;
            if (webSocketFrame.isFinalFragment()) {
                list.add(webSocketFrame.retain());
                return;
            }
            object = object.alloc().compositeBuffer().addComponent(webSocketFrame.content().retain());
            ((ByteBuf)object).writerIndex(((ByteBuf)object).writerIndex() + webSocketFrame.content().readableBytes());
            if (webSocketFrame instanceof TextWebSocketFrame) {
                this.currentFrame = new TextWebSocketFrame(true, webSocketFrame.rsv(), (ByteBuf)object);
                return;
            }
            if (webSocketFrame instanceof BinaryWebSocketFrame) {
                this.currentFrame = new BinaryWebSocketFrame(true, webSocketFrame.rsv(), (ByteBuf)object);
                return;
            }
            object.release();
            throw new IllegalStateException("WebSocket frame was not of type TextWebSocketFrame or BinaryWebSocketFrame");
        }
        if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            if (this.tooLongFrameFound) {
                if (webSocketFrame.isFinalFragment()) {
                    this.currentFrame = null;
                }
                return;
            }
            object = (CompositeByteBuf)this.currentFrame.content();
            if (((ByteBuf)object).readableBytes() > this.maxFrameSize - webSocketFrame.content().readableBytes()) {
                this.currentFrame.release();
                this.tooLongFrameFound = true;
                throw new TooLongFrameException("WebSocketFrame length exceeded " + object + " bytes.");
            }
            ((CompositeByteBuf)object).addComponent(webSocketFrame.content().retain());
            Object object2 = object;
            ((CompositeByteBuf)object2).writerIndex(((ByteBuf)object2).writerIndex() + webSocketFrame.content().readableBytes());
            if (webSocketFrame.isFinalFragment()) {
                object = this.currentFrame;
                this.currentFrame = null;
                list.add(object);
                return;
            }
            return;
        }
        list.add(webSocketFrame.retain());
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        super.channelInactive(channelHandlerContext);
        if (this.currentFrame != null) {
            this.currentFrame.release();
            this.currentFrame = null;
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved(channelHandlerContext);
        if (this.currentFrame != null) {
            this.currentFrame.release();
            this.currentFrame = null;
        }
    }
}

