/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContentCompressor;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectAggregator;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequestDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpServerCodec;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker$2;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class WebSocketServerHandshaker {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker.class);
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), WebSocketServerHandshaker.class, "handshake(...)");
    private final String uri;
    private final String[] subprotocols;
    private final WebSocketVersion version;
    private final int maxFramePayloadLength;
    private String selectedSubprotocol;
    public static final String SUB_PROTOCOL_WILDCARD = "*";

    protected WebSocketServerHandshaker(WebSocketVersion stringArray, String string, String string2, int n2) {
        this.version = stringArray;
        this.uri = string;
        if (string2 != null) {
            stringArray = string2.split(",");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
            }
            this.subprotocols = stringArray;
        } else {
            this.subprotocols = EmptyArrays.EMPTY_STRINGS;
        }
        this.maxFramePayloadLength = n2;
    }

    public String uri() {
        return this.uri;
    }

    public Set<String> subprotocols() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Collections.addAll(linkedHashSet, this.subprotocols);
        return linkedHashSet;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public ChannelFuture handshake(Channel channel, FullHttpRequest fullHttpRequest) {
        return this.handshake(channel, fullHttpRequest, null, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, FullHttpRequest fullHttpMessage, HttpHeaders iterable, ChannelPromise channelPromise) {
        Object object;
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        fullHttpMessage = this.newHandshakeResponse((FullHttpRequest)fullHttpMessage, (HttpHeaders)iterable);
        iterable = channel.pipeline();
        if (iterable.get(HttpObjectAggregator.class) != null) {
            iterable.remove(HttpObjectAggregator.class);
        }
        if (iterable.get(HttpContentCompressor.class) != null) {
            iterable.remove(HttpContentCompressor.class);
        }
        if ((object = iterable.context(HttpRequestDecoder.class)) == null) {
            object = iterable.context(HttpServerCodec.class);
            if (object == null) {
                channelPromise.setFailure(new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
                return channelPromise;
            }
            iterable.addBefore(object.name(), "wsdecoder", this.newWebsocketDecoder());
            iterable.addBefore(object.name(), "wsencoder", this.newWebSocketEncoder());
            object = object.name();
        } else {
            iterable.replace(object.name(), "wsdecoder", this.newWebsocketDecoder());
            object = iterable.context(HttpResponseEncoder.class).name();
            iterable.addBefore((String)object, "wsencoder", this.newWebSocketEncoder());
        }
        channel.writeAndFlush(fullHttpMessage).addListener(new WebSocketServerHandshaker$1(this, (String)object, channelPromise));
        return channelPromise;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest httpRequest) {
        return this.handshake(channel, httpRequest, null, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, HttpRequest httpRequest, HttpHeaders httpHeaders, ChannelPromise channelPromise) {
        ChannelPipeline channelPipeline;
        ChannelHandlerContext channelHandlerContext;
        if (httpRequest instanceof FullHttpRequest) {
            return this.handshake(channel, (FullHttpRequest)httpRequest, httpHeaders, channelPromise);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        if ((channelHandlerContext = (channelPipeline = channel.pipeline()).context(HttpRequestDecoder.class)) == null && (channelHandlerContext = channelPipeline.context(HttpServerCodec.class)) == null) {
            channelPromise.setFailure(new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
            return channelPromise;
        }
        String string = "httpAggregator";
        channelPipeline.addAfter(channelHandlerContext.name(), string, new HttpObjectAggregator(8192));
        channelPipeline.addAfter(string, "handshaker", new WebSocketServerHandshaker$2(this, channel, httpHeaders, channelPromise));
        try {
            channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpRequest));
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        return channelPromise;
    }

    protected abstract FullHttpResponse newHandshakeResponse(FullHttpRequest var1, HttpHeaders var2);

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return channel.writeAndFlush(closeWebSocketFrame, channelPromise).addListener(ChannelFutureListener.CLOSE);
    }

    protected String selectSubprotocol(String stringArray) {
        if (stringArray == null || this.subprotocols.length == 0) {
            return null;
        }
        String[] stringArray2 = stringArray.split(",");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            string = string.trim();
            String[] stringArray3 = this.subprotocols;
            int n3 = this.subprotocols.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                String string2 = stringArray3[i3];
                if (!SUB_PROTOCOL_WILDCARD.equals(string2) && !string.equals(string2)) continue;
                this.selectedSubprotocol = string;
                return string;
            }
        }
        return null;
    }

    public String selectedSubprotocol() {
        return this.selectedSubprotocol;
    }

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    static /* synthetic */ ClosedChannelException access$000() {
        return CLOSED_CHANNEL_EXCEPTION;
    }
}

