/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.util.regex.Pattern;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final Pattern BEGINNING_DIGIT = Pattern.compile("[^0-9]");
    private static final Pattern BEGINNING_SPACE = Pattern.compile("[^ ]");

    public WebSocketServerHandshaker00(String string, String string2, int n2) {
        super(WebSocketVersion.V00, string, string2, n2);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest referenceCounted, HttpHeaders object) {
        if (!referenceCounted.headers().containsValue("Connection", "Upgrade", true) || !"WebSocket".equalsIgnoreCase(referenceCounted.headers().get("Upgrade"))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean bl = referenceCounted.headers().contains("Sec-WebSocket-Key1") && referenceCounted.headers().contains("Sec-WebSocket-Key2");
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, bl ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"));
        if (object != null) {
            defaultFullHttpResponse.headers().add((HttpHeaders)object);
        }
        defaultFullHttpResponse.headers().add("Upgrade", (Object)"WebSocket");
        defaultFullHttpResponse.headers().add("Connection", (Object)"Upgrade");
        if (bl) {
            defaultFullHttpResponse.headers().add("Sec-WebSocket-Origin", (Object)referenceCounted.headers().get("Origin"));
            defaultFullHttpResponse.headers().add("Sec-WebSocket-Location", (Object)this.uri());
            object = referenceCounted.headers().get("Sec-WebSocket-Protocol");
            if (object != null) {
                String string = this.selectSubprotocol((String)object);
                if (string == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Requested subprotocol(s) not supported: {}", object);
                    }
                } else {
                    defaultFullHttpResponse.headers().add("Sec-WebSocket-Protocol", (Object)string);
                }
            }
            String string = referenceCounted.headers().get("Sec-WebSocket-Key1");
            object = referenceCounted.headers().get("Sec-WebSocket-Key2");
            int n2 = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(string).replaceAll("")) / (long)BEGINNING_SPACE.matcher(string).replaceAll("").length());
            int n3 = (int)(Long.parseLong(BEGINNING_DIGIT.matcher((CharSequence)object).replaceAll("")) / (long)BEGINNING_SPACE.matcher((CharSequence)object).replaceAll("").length());
            long l2 = referenceCounted.content().readLong();
            referenceCounted = Unpooled.buffer(16);
            ((ByteBuf)referenceCounted).writeInt(n2);
            ((ByteBuf)referenceCounted).writeInt(n3);
            ((ByteBuf)referenceCounted).writeLong(l2);
            defaultFullHttpResponse.content().writeBytes(WebSocketUtil.md5(((ByteBuf)referenceCounted).array()));
        } else {
            defaultFullHttpResponse.headers().add("WebSocket-Origin", (Object)referenceCounted.headers().get("Origin"));
            defaultFullHttpResponse.headers().add("WebSocket-Location", (Object)this.uri());
            object = referenceCounted.headers().get("WebSocket-Protocol");
            if (object != null) {
                defaultFullHttpResponse.headers().add("WebSocket-Protocol", (Object)this.selectSubprotocol((String)object));
            }
        }
        return defaultFullHttpResponse;
    }

    @Override
    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return channel.writeAndFlush(closeWebSocketFrame, channelPromise);
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket00FrameDecoder(this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket00FrameEncoder();
    }
}

