/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker13
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker13(String string, String string2, boolean bl, int n2) {
        super(WebSocketVersion.V13, string, string2, n2);
        this.allowExtensions = bl;
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest object, HttpHeaders object2) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        if (object2 != null) {
            defaultFullHttpResponse.headers().add((HttpHeaders)object2);
        }
        if ((object2 = object.headers().get("Sec-WebSocket-Key")) == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        Object object3 = (String)object2 + WEBSOCKET_13_ACCEPT_GUID;
        byte[] byArray = WebSocketUtil.sha1(((String)object3).getBytes(CharsetUtil.US_ASCII));
        object3 = byArray;
        object3 = WebSocketUtil.base64(byArray);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 server handshake key: {}, response: {}", object2, object3);
        }
        defaultFullHttpResponse.headers().add("Upgrade", (Object)"WebSocket".toLowerCase());
        defaultFullHttpResponse.headers().add("Connection", (Object)"Upgrade");
        defaultFullHttpResponse.headers().add("Sec-WebSocket-Accept", object3);
        object = object.headers().get("Sec-WebSocket-Protocol");
        if (object != null) {
            object2 = this.selectSubprotocol((String)object);
            if (object2 == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", object);
                }
            } else {
                defaultFullHttpResponse.headers().add("Sec-WebSocket-Protocol", object2);
            }
        }
        return defaultFullHttpResponse;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(true, this.allowExtensions, this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(false);
    }
}

