/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler;
import com.aliyun.openservices.shade.io.netty.util.AttributeKey;
import java.util.List;

public class WebSocketServerProtocolHandler
extends WebSocketProtocolHandler {
    private static final AttributeKey<WebSocketServerHandshaker> HANDSHAKER_ATTR_KEY = AttributeKey.valueOf(WebSocketServerHandshaker.class.getName() + ".HANDSHAKER");
    private final String websocketPath;
    private final String subprotocols;
    private final boolean allowExtensions;
    private final int maxFramePayloadLength;

    public WebSocketServerProtocolHandler(String string) {
        this(string, null, false);
    }

    public WebSocketServerProtocolHandler(String string, String string2) {
        this(string, string2, false);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl) {
        this(string, string2, bl, 65536);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n2) {
        this.websocketPath = string;
        this.subprotocols = string2;
        this.allowExtensions = bl;
        this.maxFramePayloadLength = n2;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (channelPipeline.get(WebSocketServerProtocolHandshakeHandler.class) == null) {
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), WebSocketServerProtocolHandshakeHandler.class.getName(), new WebSocketServerProtocolHandshakeHandler(this.websocketPath, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength));
        }
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> object) {
        if (webSocketFrame instanceof CloseWebSocketFrame) {
            object = WebSocketServerProtocolHandler.getHandshaker(channelHandlerContext.channel());
            if (object != null) {
                webSocketFrame.retain();
                ((WebSocketServerHandshaker)object).close(channelHandlerContext.channel(), (CloseWebSocketFrame)webSocketFrame);
                return;
            }
            channelHandlerContext.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        super.decode(channelHandlerContext, webSocketFrame, (List<Object>)object);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable object) {
        if (object instanceof WebSocketHandshakeException) {
            object = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer(((Throwable)object).getMessage().getBytes()));
            channelHandlerContext.channel().writeAndFlush(object).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        channelHandlerContext.close();
    }

    static WebSocketServerHandshaker getHandshaker(Channel channel) {
        return channel.attr(HANDSHAKER_ATTR_KEY).get();
    }

    static void setHandshaker(Channel channel, WebSocketServerHandshaker webSocketServerHandshaker) {
        channel.attr(HANDSHAKER_ATTR_KEY).set(webSocketServerHandshaker);
    }

    static ChannelHandler forbiddenHttpRequestResponder() {
        return new WebSocketServerProtocolHandler$1();
    }
}

