/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler$1;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final String websocketPath;
    private final String subprotocols;
    private final boolean allowExtensions;
    private final int maxFramePayloadSize;

    WebSocketServerProtocolHandshakeHandler(String string, String string2, boolean bl, int n2) {
        this.websocketPath = string;
        this.subprotocols = string2;
        this.allowExtensions = bl;
        this.maxFramePayloadSize = n2;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        FullHttpRequest fullHttpRequest = (FullHttpRequest)object;
        if (!this.websocketPath.equals(fullHttpRequest.getUri())) {
            channelHandlerContext.fireChannelRead(object);
            return;
        }
        try {
            if (fullHttpRequest.getMethod() != HttpMethod.GET) {
                WebSocketServerProtocolHandshakeHandler.sendHttpResponse(channelHandlerContext, fullHttpRequest, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
                return;
            }
            object = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(channelHandlerContext.pipeline(), fullHttpRequest, this.websocketPath), this.subprotocols, this.allowExtensions, this.maxFramePayloadSize);
            if ((object = ((WebSocketServerHandshakerFactory)object).newHandshaker(fullHttpRequest)) == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channelHandlerContext.channel());
            } else {
                ChannelFuture channelFuture = ((WebSocketServerHandshaker)object).handshake(channelHandlerContext.channel(), fullHttpRequest);
                channelFuture.addListener(new WebSocketServerProtocolHandshakeHandler$1(this, channelHandlerContext));
                WebSocketServerProtocolHandler.setHandshaker(channelHandlerContext.channel(), (WebSocketServerHandshaker)object);
                channelHandlerContext.pipeline().replace(this, "WS403Responder", WebSocketServerProtocolHandler.forbiddenHttpRequestResponder());
            }
            return;
        }
        finally {
            fullHttpRequest.release();
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext object, HttpRequest httpRequest, HttpResponse httpResponse) {
        object = object.channel().writeAndFlush(httpResponse);
        if (!HttpHeaders.isKeepAlive(httpRequest) || httpResponse.getStatus().code() != 200) {
            object.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline channelPipeline, HttpRequest httpRequest, String string) {
        String string2 = "ws";
        if (channelPipeline.get(SslHandler.class) != null) {
            string2 = "wss";
        }
        return string2 + "://" + httpRequest.headers().get("Host") + string;
    }
}

