/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.marshalling;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ReplayingDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.marshalling.ChannelBufferByteInput;
import com.aliyun.openservices.shade.io.netty.handler.codec.marshalling.LimitingByteInput;
import com.aliyun.openservices.shade.io.netty.handler.codec.marshalling.LimitingByteInput$TooBigObjectException;
import com.aliyun.openservices.shade.io.netty.handler.codec.marshalling.UnmarshallerProvider;
import java.util.List;
import org.jboss.marshalling.ByteInput;

public class CompatibleMarshallingDecoder
extends ReplayingDecoder<Void> {
    protected final UnmarshallerProvider provider;
    protected final int maxObjectSize;
    private boolean discardingTooLongFrame;

    public CompatibleMarshallingDecoder(UnmarshallerProvider unmarshallerProvider, int n2) {
        this.provider = unmarshallerProvider;
        this.maxObjectSize = n2;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf object, List<Object> list) {
        if (this.discardingTooLongFrame) {
            ((ByteBuf)object).skipBytes(this.actualReadableBytes());
            this.checkpoint();
            return;
        }
        channelHandlerContext = this.provider.getUnmarshaller(channelHandlerContext);
        object = new ChannelBufferByteInput((ByteBuf)object);
        if (this.maxObjectSize != Integer.MAX_VALUE) {
            object = new LimitingByteInput((ByteInput)object, this.maxObjectSize);
        }
        try {
            channelHandlerContext.start((ByteInput)object);
            object = channelHandlerContext.readObject();
            channelHandlerContext.finish();
            list.add(object);
            return;
        }
        catch (LimitingByteInput$TooBigObjectException limitingByteInput$TooBigObjectException) {
            this.discardingTooLongFrame = true;
            throw new TooLongFrameException();
        }
        finally {
            channelHandlerContext.close();
        }
    }

    @Override
    public void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        switch (byteBuf.readableBytes()) {
            case 0: {
                return;
            }
            case 1: {
                ByteBuf byteBuf2 = byteBuf;
                if (byteBuf2.getByte(byteBuf2.readerIndex()) != 121) break;
                byteBuf.skipBytes(1);
                return;
            }
        }
        this.decode(channelHandlerContext, byteBuf, list);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof TooLongFrameException) {
            channelHandlerContext.close();
            return;
        }
        super.exceptionCaught(channelHandlerContext, throwable);
    }
}

