/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.marshalling;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler$Sharable;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToByteEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import com.aliyun.openservices.shade.io.netty.handler.codec.marshalling.MarshallerProvider;

@ChannelHandler$Sharable
public class MarshallingEncoder
extends MessageToByteEncoder<Object> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;

    public MarshallingEncoder(MarshallerProvider marshallerProvider) {
        this.provider = marshallerProvider;
    }

    @Override
    public void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) {
        channelHandlerContext = this.provider.getMarshaller(channelHandlerContext);
        int n2 = byteBuf.writerIndex();
        byteBuf.writeBytes(LENGTH_PLACEHOLDER);
        ChannelBufferByteOutput channelBufferByteOutput = new ChannelBufferByteOutput(byteBuf);
        channelHandlerContext.start(channelBufferByteOutput);
        channelHandlerContext.writeObject(object);
        channelHandlerContext.finish();
        channelHandlerContext.close();
        byteBuf.setInt(n2, byteBuf.writerIndex() - n2 - 4);
    }
}

