/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.protobuf;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.CorruptedFrameException;
import com.google.protobuf.CodedInputStream;
import java.util.List;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    public void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        byteBuf.markReaderIndex();
        object = new byte[5];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (!byteBuf.isReadable()) {
                byteBuf.resetReaderIndex();
                return;
            }
            object[i2] = byteBuf.readByte();
            if (object[i2] < 0) continue;
            int n2 = CodedInputStream.newInstance((byte[])object, (int)0, (int)(i2 + 1)).readRawVarint32();
            if (n2 < 0) {
                throw new CorruptedFrameException("negative length: " + n2);
            }
            if (byteBuf.readableBytes() < n2) {
                byteBuf.resetReaderIndex();
                return;
            }
            list.add(byteBuf.readSlice(n2).retain());
            return;
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }
}

