/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.rtsp;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.handler.codec.UnsupportedMessageTypeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final byte[] CRLF = new byte[]{13, 10};

    @Override
    public boolean acceptOutboundMessage(Object object) {
        return super.acceptOutboundMessage(object) && (object instanceof HttpRequest || object instanceof HttpResponse);
    }

    @Override
    public void encodeInitialLine(ByteBuf byteBuf, HttpMessage httpMessage) {
        if (httpMessage instanceof HttpRequest) {
            httpMessage = (HttpRequest)httpMessage;
            HttpHeaders.encodeAscii(httpMessage.getMethod().toString(), byteBuf);
            byteBuf.writeByte(32);
            byteBuf.writeBytes(httpMessage.getUri().getBytes(CharsetUtil.UTF_8));
            byteBuf.writeByte(32);
            HttpHeaders.encodeAscii(httpMessage.getProtocolVersion().toString(), byteBuf);
            byteBuf.writeBytes(CRLF);
            return;
        }
        if (httpMessage instanceof HttpResponse) {
            httpMessage = (HttpResponse)httpMessage;
            HttpHeaders.encodeAscii(httpMessage.getProtocolVersion().toString(), byteBuf);
            byteBuf.writeByte(32);
            byteBuf.writeBytes(String.valueOf(httpMessage.getStatus().code()).getBytes(CharsetUtil.US_ASCII));
            byteBuf.writeByte(32);
            HttpHeaders.encodeAscii(String.valueOf(httpMessage.getStatus().reasonPhrase()), byteBuf);
            byteBuf.writeBytes(CRLF);
            return;
        }
        throw new UnsupportedMessageTypeException("Unsupported type " + StringUtil.simpleClassName(httpMessage));
    }
}

