/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.sctp;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SctpMessageCompletionHandler
extends MessageToMessageDecoder<SctpMessage> {
    private final Map<Integer, ByteBuf> fragments = new HashMap<Integer, ByteBuf>();

    @Override
    protected void decode(ChannelHandlerContext object, SctpMessage sctpMessage, List<Object> list) {
        object = sctpMessage.content();
        int n2 = sctpMessage.protocolIdentifier();
        int n3 = sctpMessage.streamIdentifier();
        boolean bl = sctpMessage.isComplete();
        boolean bl2 = sctpMessage.isUnordered();
        ByteBuf byteBuf = this.fragments.remove(n3);
        if (byteBuf == null) {
            byteBuf = Unpooled.EMPTY_BUFFER;
        }
        if (bl && !byteBuf.isReadable()) {
            list.add(sctpMessage);
        } else if (!bl && byteBuf.isReadable()) {
            this.fragments.put(n3, Unpooled.wrappedBuffer(new ByteBuf[]{byteBuf, object}));
        } else if (bl && byteBuf.isReadable()) {
            sctpMessage = new SctpMessage(n2, n3, bl2, Unpooled.wrappedBuffer(new ByteBuf[]{byteBuf, object}));
            list.add(sctpMessage);
        } else {
            this.fragments.put(n3, (ByteBuf)object);
        }
        ((ByteBuf)object).retain();
    }
}

