/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.serialization;

import com.aliyun.openservices.shade.io.netty.handler.codec.serialization.ClassResolver;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

class CompactObjectInputStream
extends ObjectInputStream {
    private final ClassResolver classResolver;

    CompactObjectInputStream(InputStream inputStream, ClassResolver classResolver) {
        super(inputStream);
        this.classResolver = classResolver;
    }

    @Override
    protected void readStreamHeader() {
        int n2 = this.readByte() & 0xFF;
        if (n2 != 5) {
            throw new StreamCorruptedException("Unsupported version: " + n2);
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        switch (n2) {
            case 0: {
                return super.readClassDescriptor();
            }
            case 1: {
                Object object = this.readUTF();
                object = this.classResolver.resolve((String)object);
                return ObjectStreamClass.lookupAny(object);
            }
        }
        throw new StreamCorruptedException("Unexpected class descriptor type: " + n2);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
        Class<?> clazz;
        try {
            clazz = this.classResolver.resolve(objectStreamClass.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = super.resolveClass(objectStreamClass);
        }
        return clazz;
    }
}

