/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.serialization;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufOutputStream;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToByteEncoder;
import com.aliyun.openservices.shade.io.netty.util.AttributeKey;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CompatibleObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final AttributeKey<ObjectOutputStream> OOS = AttributeKey.valueOf(CompatibleObjectEncoder.class.getName() + ".OOS");
    private final int resetInterval;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    public CompatibleObjectEncoder(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("resetInterval: " + n2);
        }
        this.resetInterval = n2;
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream outputStream) {
        return new ObjectOutputStream(outputStream);
    }

    @Override
    protected void encode(ChannelHandlerContext object, Serializable serializable, ByteBuf byteBuf) {
        Object object2 = (object = object.attr(OOS)).get();
        if (object2 == null && (object = object.setIfAbsent(object2 = this.newObjectOutputStream(new ByteBufOutputStream(byteBuf)))) != null) {
            object2 = object;
        }
        object = object2;
        synchronized (object) {
            if (this.resetInterval != 0) {
                ++this.writtenObjects;
                if (this.writtenObjects % this.resetInterval == 0) {
                    ((ObjectOutputStream)object2).reset();
                }
            }
            ((ObjectOutputStream)object2).writeObject(serializable);
            ((ObjectOutputStream)object2).flush();
            return;
        }
    }
}

