/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.socks;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ReplayingDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksAddressType;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCmdRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCmdRequestDecoder$State;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCmdType;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCommonUtils;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksProtocolVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksRequest;
import java.util.List;

public class SocksCmdRequestDecoder
extends ReplayingDecoder<SocksCmdRequestDecoder$State> {
    private static final String name = "SOCKS_CMD_REQUEST_DECODER";
    private SocksProtocolVersion version;
    private int fieldLength;
    private SocksCmdType cmdType;
    private SocksAddressType addressType;
    private byte reserved;
    private String host;
    private int port;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    @Deprecated
    public static String getName() {
        return name;
    }

    public SocksCmdRequestDecoder() {
        super(SocksCmdRequestDecoder$State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        block0 : switch ((SocksCmdRequestDecoder$State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksProtocolVersion.valueOf(byteBuf.readByte());
                if (this.version != SocksProtocolVersion.SOCKS5) break;
                this.checkpoint(SocksCmdRequestDecoder$State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdType = SocksCmdType.valueOf(byteBuf.readByte());
                this.reserved = byteBuf.readByte();
                this.addressType = SocksAddressType.valueOf(byteBuf.readByte());
                this.checkpoint(SocksCmdRequestDecoder$State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        this.host = SocksCommonUtils.intToIp(byteBuf.readInt());
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdRequest(this.cmdType, this.addressType, this.host, this.port);
                        break block0;
                    }
                    case DOMAIN: {
                        this.fieldLength = byteBuf.readByte();
                        this.host = SocksCommonUtils.readUsAscii(byteBuf, this.fieldLength);
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdRequest(this.cmdType, this.addressType, this.host, this.port);
                        break block0;
                    }
                    case IPv6: {
                        byte[] byArray = new byte[16];
                        byteBuf.readBytes(byArray);
                        this.host = SocksCommonUtils.ipv6toStr(byArray);
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdRequest(this.cmdType, this.addressType, this.host, this.port);
                    }
                }
            }
        }
        channelHandlerContext.pipeline().remove(this);
        list.add(this.msg);
    }
}

