/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.socks;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ReplayingDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksAddressType;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCmdResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCmdResponseDecoder$State;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCmdStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksCommonUtils;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksProtocolVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksResponse;
import java.util.List;

public class SocksCmdResponseDecoder
extends ReplayingDecoder<SocksCmdResponseDecoder$State> {
    private static final String name = "SOCKS_CMD_RESPONSE_DECODER";
    private SocksProtocolVersion version;
    private int fieldLength;
    private SocksCmdStatus cmdStatus;
    private SocksAddressType addressType;
    private byte reserved;
    private String host;
    private int port;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    @Deprecated
    public static String getName() {
        return name;
    }

    public SocksCmdResponseDecoder() {
        super(SocksCmdResponseDecoder$State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        block0 : switch ((SocksCmdResponseDecoder$State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksProtocolVersion.valueOf(byteBuf.readByte());
                if (this.version != SocksProtocolVersion.SOCKS5) break;
                this.checkpoint(SocksCmdResponseDecoder$State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdStatus = SocksCmdStatus.valueOf(byteBuf.readByte());
                this.reserved = byteBuf.readByte();
                this.addressType = SocksAddressType.valueOf(byteBuf.readByte());
                this.checkpoint(SocksCmdResponseDecoder$State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        this.host = SocksCommonUtils.intToIp(byteBuf.readInt());
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType, this.host, this.port);
                        break block0;
                    }
                    case DOMAIN: {
                        this.fieldLength = byteBuf.readByte();
                        this.host = SocksCommonUtils.readUsAscii(byteBuf, this.fieldLength);
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType, this.host, this.port);
                        break block0;
                    }
                    case IPv6: {
                        byte[] byArray = new byte[16];
                        byteBuf.readBytes(byArray);
                        this.host = SocksCommonUtils.ipv6toStr(byArray);
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType, this.host, this.port);
                    }
                }
            }
        }
        channelHandlerContext.pipeline().remove(this);
        list.add(this.msg);
    }
}

