/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.socks;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.SocksResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.UnknownSocksRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.socks.UnknownSocksResponse;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;

final class SocksCommonUtils {
    public static final SocksRequest UNKNOWN_SOCKS_REQUEST = new UnknownSocksRequest();
    public static final SocksResponse UNKNOWN_SOCKS_RESPONSE = new UnknownSocksResponse();
    private static final int SECOND_ADDRESS_OCTET_SHIFT = 16;
    private static final int FIRST_ADDRESS_OCTET_SHIFT = 24;
    private static final int THIRD_ADDRESS_OCTET_SHIFT = 8;
    private static final int XOR_DEFAULT_VALUE = 255;
    private static final char[] ipv6conseqZeroFiller = new char[]{':', ':'};
    private static final char ipv6hextetSeparator = ':';

    private SocksCommonUtils() {
    }

    public static String intToIp(int n2) {
        return String.valueOf(n2 >>> 24) + '.' + (n2 >> 16 & 0xFF) + '.' + (n2 >> 8 & 0xFF) + '.' + (n2 & 0xFF);
    }

    public static String ipv6toCompressedForm(byte[] byArray) {
        assert (byArray.length == 16);
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 8) {
            int n5 = n4 << 1;
            int n6 = 0;
            while (n5 < byArray.length && byArray[n5] == 0 && byArray[n5 + 1] == 0) {
                n5 += 2;
                ++n6;
            }
            if (n6 > n3) {
                n2 = n4;
                n3 = n6;
            }
            n4 = n5 / 2 + 1;
        }
        if (n2 == -1 || n3 < 2) {
            return SocksCommonUtils.ipv6toStr(byArray);
        }
        StringBuilder stringBuilder = new StringBuilder(39);
        SocksCommonUtils.ipv6toStr(stringBuilder, byArray, 0, n2);
        stringBuilder.append(ipv6conseqZeroFiller);
        SocksCommonUtils.ipv6toStr(stringBuilder, byArray, n2 + n3, 8);
        return stringBuilder.toString();
    }

    public static String ipv6toStr(byte[] byArray) {
        assert (byArray.length == 16);
        StringBuilder stringBuilder = new StringBuilder(39);
        SocksCommonUtils.ipv6toStr(stringBuilder, byArray, 0, 8);
        return stringBuilder.toString();
    }

    private static void ipv6toStr(StringBuilder stringBuilder, byte[] byArray, int n2, int n3) {
        --n3;
        while (n2 < n3) {
            SocksCommonUtils.appendHextet(stringBuilder, byArray, n2);
            stringBuilder.append(':');
            ++n2;
        }
        SocksCommonUtils.appendHextet(stringBuilder, byArray, n2);
    }

    private static void appendHextet(StringBuilder stringBuilder, byte[] byArray, int n2) {
        StringUtil.toHexString(stringBuilder, byArray, n2 << 1, 2);
    }

    static String readUsAscii(ByteBuf byteBuf, int n2) {
        ByteBuf byteBuf2 = byteBuf;
        String string = byteBuf2.toString(byteBuf2.readerIndex(), n2, CharsetUtil.US_ASCII);
        byteBuf.skipBytes(n2);
        return string;
    }
}

