/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyDataFrame;
import com.aliyun.openservices.shade.io.netty.util.IllegalReferenceCountException;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
extends DefaultSpdyStreamFrame
implements SpdyDataFrame {
    private final ByteBuf data;

    public DefaultSpdyDataFrame(int n2) {
        this(n2, Unpooled.buffer(0));
    }

    public DefaultSpdyDataFrame(int n2, ByteBuf byteBuf) {
        super(n2);
        if (byteBuf == null) {
            throw new NullPointerException("data");
        }
        this.data = DefaultSpdyDataFrame.validate(byteBuf);
    }

    private static ByteBuf validate(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        return byteBuf;
    }

    @Override
    public SpdyDataFrame setStreamId(int n2) {
        super.setStreamId(n2);
        return this;
    }

    @Override
    public SpdyDataFrame setLast(boolean bl) {
        super.setLast(bl);
        return this;
    }

    @Override
    public ByteBuf content() {
        if (this.data.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.data.refCnt());
        }
        return this.data;
    }

    @Override
    public SpdyDataFrame copy() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(this.streamId(), this.content().copy());
        defaultSpdyDataFrame.setLast(this.isLast());
        return defaultSpdyDataFrame;
    }

    @Override
    public SpdyDataFrame duplicate() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(this.streamId(), this.content().duplicate());
        defaultSpdyDataFrame.setLast(this.isLast());
        return defaultSpdyDataFrame;
    }

    @Override
    public int refCnt() {
        return this.data.refCnt();
    }

    @Override
    public SpdyDataFrame retain() {
        this.data.retain();
        return this;
    }

    @Override
    public SpdyDataFrame retain(int n2) {
        this.data.retain(n2);
        return this;
    }

    @Override
    public boolean release() {
        return this.data.release();
    }

    @Override
    public boolean release(int n2) {
        return this.data.release(n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(last: ").append(this.isLast()).append(')').append(StringUtil.NEWLINE).append("--> Stream-ID = ").append(this.streamId()).append(StringUtil.NEWLINE).append("--> Size = ");
        if (this.refCnt() == 0) {
            stringBuilder.append("(freed)");
        } else {
            stringBuilder.append(this.content().readableBytes());
        }
        return stringBuilder.toString();
    }
}

