/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.UnsupportedMessageTypeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyDataFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyFrameCodec$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyPingFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyProtocolException;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySettingsFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySynReplyFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySynStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import java.net.SocketAddress;
import java.util.List;

public class SpdyFrameCodec
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
SpdyFrameDecoderDelegate {
    private static final SpdyProtocolException INVALID_FRAME = new SpdyProtocolException("Received invalid frame");
    private final SpdyFrameDecoder spdyFrameDecoder;
    private final SpdyFrameEncoder spdyFrameEncoder;
    private final SpdyHeaderBlockDecoder spdyHeaderBlockDecoder;
    private final SpdyHeaderBlockEncoder spdyHeaderBlockEncoder;
    private SpdyHeadersFrame spdyHeadersFrame;
    private SpdySettingsFrame spdySettingsFrame;
    private ChannelHandlerContext ctx;
    private boolean read;

    public SpdyFrameCodec(SpdyVersion spdyVersion) {
        this(spdyVersion, 8192, 16384, 6, 15, 8);
    }

    public SpdyFrameCodec(SpdyVersion spdyVersion, int n2, int n3, int n4, int n5, int n6) {
        this(spdyVersion, n2, SpdyHeaderBlockDecoder.newInstance(spdyVersion, n3), SpdyHeaderBlockEncoder.newInstance(spdyVersion, n4, n5, n6));
    }

    protected SpdyFrameCodec(SpdyVersion spdyVersion, int n2, SpdyHeaderBlockDecoder spdyHeaderBlockDecoder, SpdyHeaderBlockEncoder spdyHeaderBlockEncoder) {
        this.spdyFrameDecoder = new SpdyFrameDecoder(spdyVersion, this, n2);
        this.spdyFrameEncoder = new SpdyFrameEncoder(spdyVersion);
        this.spdyHeaderBlockDecoder = spdyHeaderBlockDecoder;
        this.spdyHeaderBlockEncoder = spdyHeaderBlockEncoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        this.ctx = channelHandlerContext;
        channelHandlerContext.channel().closeFuture().addListener(new SpdyFrameCodec$1(this));
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.spdyFrameDecoder.decode(byteBuf);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (!this.read && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        this.read = false;
        super.channelReadComplete(channelHandlerContext);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame) {
            object = (SpdyDataFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeDataFrame(channelHandlerContext.alloc(), object.streamId(), object.isLast(), object.content());
            object.release();
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdySynStreamFrame) {
            ByteBuf byteBuf;
            object = (SpdySynStreamFrame)object;
            ByteBuf byteBuf2 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), (SpdyHeadersFrame)object);
            try {
                byteBuf = this.spdyFrameEncoder.encodeSynStreamFrame(channelHandlerContext.alloc(), object.streamId(), object.associatedStreamId(), object.priority(), object.isLast(), object.isUnidirectional(), byteBuf2);
            }
            finally {
                byteBuf2.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdySynReplyFrame) {
            ByteBuf byteBuf;
            object = (SpdySynReplyFrame)object;
            ByteBuf byteBuf3 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), (SpdyHeadersFrame)object);
            try {
                byteBuf = this.spdyFrameEncoder.encodeSynReplyFrame(channelHandlerContext.alloc(), object.streamId(), object.isLast(), byteBuf3);
            }
            finally {
                byteBuf3.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdyRstStreamFrame) {
            object = (SpdyRstStreamFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeRstStreamFrame(channelHandlerContext.alloc(), object.streamId(), object.status().code());
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdySettingsFrame) {
            object = (SpdySettingsFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeSettingsFrame(channelHandlerContext.alloc(), (SpdySettingsFrame)object);
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdyPingFrame) {
            object = (SpdyPingFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodePingFrame(channelHandlerContext.alloc(), object.id());
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdyGoAwayFrame) {
            object = (SpdyGoAwayFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeGoAwayFrame(channelHandlerContext.alloc(), object.lastGoodStreamId(), object.status().code());
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdyHeadersFrame) {
            ByteBuf byteBuf;
            object = (SpdyHeadersFrame)object;
            ByteBuf byteBuf4 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), (SpdyHeadersFrame)object);
            try {
                byteBuf = this.spdyFrameEncoder.encodeHeadersFrame(channelHandlerContext.alloc(), object.streamId(), object.isLast(), byteBuf4);
            }
            finally {
                byteBuf4.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        if (object instanceof SpdyWindowUpdateFrame) {
            object = (SpdyWindowUpdateFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeWindowUpdateFrame(channelHandlerContext.alloc(), object.streamId(), object.deltaWindowSize());
            channelHandlerContext.write(byteBuf, channelPromise);
            return;
        }
        throw new UnsupportedMessageTypeException(object, new Class[0]);
    }

    @Override
    public void readDataFrame(int n2, boolean bl, ByteBuf byteBuf) {
        this.read = true;
        DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n2, byteBuf);
        defaultSpdyDataFrame.setLast(bl);
        this.ctx.fireChannelRead(defaultSpdyDataFrame);
    }

    @Override
    public void readSynStreamFrame(int n2, int n3, byte by, boolean bl, boolean bl2) {
        DefaultSpdySynStreamFrame defaultSpdySynStreamFrame = new DefaultSpdySynStreamFrame(n2, n3, by);
        defaultSpdySynStreamFrame.setLast(bl);
        defaultSpdySynStreamFrame.setUnidirectional(bl2);
        this.spdyHeadersFrame = defaultSpdySynStreamFrame;
    }

    @Override
    public void readSynReplyFrame(int n2, boolean bl) {
        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n2);
        defaultSpdySynReplyFrame.setLast(bl);
        this.spdyHeadersFrame = defaultSpdySynReplyFrame;
    }

    @Override
    public void readRstStreamFrame(int n2, int n3) {
        this.read = true;
        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n2, n3);
        this.ctx.fireChannelRead(defaultSpdyRstStreamFrame);
    }

    @Override
    public void readSettingsFrame(boolean bl) {
        this.read = true;
        this.spdySettingsFrame = new DefaultSpdySettingsFrame();
        this.spdySettingsFrame.setClearPreviouslyPersistedSettings(bl);
    }

    @Override
    public void readSetting(int n2, int n3, boolean bl, boolean bl2) {
        this.spdySettingsFrame.setValue(n2, n3, bl, bl2);
    }

    @Override
    public void readSettingsEnd() {
        this.read = true;
        SpdySettingsFrame spdySettingsFrame = this.spdySettingsFrame;
        this.spdySettingsFrame = null;
        this.ctx.fireChannelRead(spdySettingsFrame);
    }

    @Override
    public void readPingFrame(int n2) {
        this.read = true;
        DefaultSpdyPingFrame defaultSpdyPingFrame = new DefaultSpdyPingFrame(n2);
        this.ctx.fireChannelRead(defaultSpdyPingFrame);
    }

    @Override
    public void readGoAwayFrame(int n2, int n3) {
        this.read = true;
        DefaultSpdyGoAwayFrame defaultSpdyGoAwayFrame = new DefaultSpdyGoAwayFrame(n2, n3);
        this.ctx.fireChannelRead(defaultSpdyGoAwayFrame);
    }

    @Override
    public void readHeadersFrame(int n2, boolean bl) {
        this.spdyHeadersFrame = new DefaultSpdyHeadersFrame(n2);
        this.spdyHeadersFrame.setLast(bl);
    }

    @Override
    public void readWindowUpdateFrame(int n2, int n3) {
        this.read = true;
        DefaultSpdyWindowUpdateFrame defaultSpdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(n2, n3);
        this.ctx.fireChannelRead(defaultSpdyWindowUpdateFrame);
    }

    @Override
    public void readHeaderBlock(ByteBuf byteBuf) {
        try {
            this.spdyHeaderBlockDecoder.decode(this.ctx.alloc(), byteBuf, this.spdyHeadersFrame);
            return;
        }
        catch (Exception exception) {
            this.ctx.fireExceptionCaught(exception);
            return;
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void readHeaderBlockEnd() {
        SpdyHeadersFrame spdyHeadersFrame = null;
        try {
            this.spdyHeaderBlockDecoder.endHeaderBlock(this.spdyHeadersFrame);
            spdyHeadersFrame = this.spdyHeadersFrame;
            this.spdyHeadersFrame = null;
        }
        catch (Exception exception) {
            this.ctx.fireExceptionCaught(exception);
        }
        if (spdyHeadersFrame != null) {
            this.read = true;
            this.ctx.fireChannelRead(spdyHeadersFrame);
        }
    }

    @Override
    public void readFrameError(String string) {
        this.ctx.fireExceptionCaught(INVALID_FRAME);
    }

    static /* synthetic */ SpdyHeaderBlockDecoder access$000(SpdyFrameCodec spdyFrameCodec) {
        return spdyFrameCodec.spdyHeaderBlockDecoder;
    }

    static /* synthetic */ SpdyHeaderBlockEncoder access$100(SpdyFrameCodec spdyFrameCodec) {
        return spdyFrameCodec.spdyHeaderBlockEncoder;
    }
}

