/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyCodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyFrameDecoder$State;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;

public class SpdyFrameDecoder {
    private final int spdyVersion;
    private final int maxChunkSize;
    private final SpdyFrameDecoderDelegate delegate;
    private SpdyFrameDecoder$State state;
    private byte flags;
    private int length;
    private int streamId;
    private int numSettings;

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate) {
        this(spdyVersion, spdyFrameDecoderDelegate, 8192);
    }

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate, int n2) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        if (spdyFrameDecoderDelegate == null) {
            throw new NullPointerException("delegate");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + n2);
        }
        this.spdyVersion = spdyVersion.getVersion();
        this.delegate = spdyFrameDecoderDelegate;
        this.maxChunkSize = n2;
        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
    }

    public void decode(ByteBuf byteBuf) {
        block16: while (true) {
            switch (this.state) {
                case READ_COMMON_HEADER: {
                    int n2;
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    int by = byteBuf.readerIndex();
                    int n3 = by + 4;
                    byte by2 = by + 5;
                    byteBuf.skipBytes(8);
                    int n4 = (byteBuf.getByte(by) & 0x80) != 0;
                    if (n4) {
                        n4 = SpdyCodecUtil.getUnsignedShort(byteBuf, by) & Short.MAX_VALUE;
                        n2 = SpdyCodecUtil.getUnsignedShort(byteBuf, by + 2);
                        this.streamId = 0;
                    } else {
                        n4 = this.spdyVersion;
                        n2 = 0;
                        this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, by);
                    }
                    this.flags = byteBuf.getByte(n3);
                    this.length = SpdyCodecUtil.getUnsignedMedium(byteBuf, by2);
                    if (n4 != this.spdyVersion) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SPDY Version");
                        continue block16;
                    }
                    if (!SpdyFrameDecoder.isValidFrameHeader(this.streamId, n2, this.flags, this.length)) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid Frame Error");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder.getNextState(n2, this.length);
                    continue block16;
                }
                case READ_DATA_FRAME: {
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readDataFrame(this.streamId, SpdyFrameDecoder.hasFlag(this.flags, (byte)1), Unpooled.buffer(0));
                        continue block16;
                    }
                    int by = Math.min(this.maxChunkSize, this.length);
                    if (byteBuf.readableBytes() < by) {
                        return;
                    }
                    ByteBuf byteBuf2 = byteBuf.alloc().buffer(by);
                    byteBuf2.writeBytes(byteBuf, by);
                    this.length -= by;
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    }
                    by = this.length == 0 && SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? (int)1 : 0;
                    this.delegate.readDataFrame(this.streamId, by != 0, byteBuf2);
                    continue block16;
                }
                case READ_SYN_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 10) {
                        return;
                    }
                    int by = byteBuf.readerIndex();
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, by);
                    int n5 = SpdyCodecUtil.getUnsignedInt(byteBuf, by + 4);
                    byte by2 = (byte)(byteBuf.getByte(by + 8) >> 5 & 7);
                    by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    int n4 = SpdyFrameDecoder.hasFlag(this.flags, (byte)2) ? 1 : 0;
                    byteBuf.skipBytes(10);
                    this.length -= 10;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_STREAM Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readSynStreamFrame(this.streamId, n5, by2, by != 0, n4 != 0);
                    continue block16;
                }
                case READ_SYN_REPLY_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    ByteBuf byteBuf2 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf2, byteBuf2.readerIndex());
                    int by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_REPLY Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readSynReplyFrame(this.streamId, by != 0);
                    continue block16;
                }
                case READ_RST_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf3 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf3, byteBuf3.readerIndex());
                    ByteBuf byteBuf4 = byteBuf;
                    int by = SpdyCodecUtil.getSignedInt(byteBuf4, byteBuf4.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (this.streamId == 0 || by == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid RST_STREAM Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readRstStreamFrame(this.streamId, by);
                    continue block16;
                }
                case READ_SETTINGS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    int by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    ByteBuf byteBuf5 = byteBuf;
                    this.numSettings = SpdyCodecUtil.getUnsignedInt(byteBuf5, byteBuf5.readerIndex());
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if ((this.length & 7) != 0 || this.length >> 3 != this.numSettings) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SETTINGS Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_SETTING;
                    this.delegate.readSettingsFrame(by != 0);
                    continue block16;
                }
                case READ_SETTING: {
                    if (this.numSettings == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readSettingsEnd();
                        continue block16;
                    }
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf6 = byteBuf;
                    int by = byteBuf6.getByte(byteBuf6.readerIndex());
                    ByteBuf byteBuf7 = byteBuf;
                    int n6 = SpdyCodecUtil.getUnsignedMedium(byteBuf7, byteBuf7.readerIndex() + 1);
                    ByteBuf byteBuf8 = byteBuf;
                    byte by2 = SpdyCodecUtil.getSignedInt(byteBuf8, byteBuf8.readerIndex() + 4);
                    int n4 = SpdyFrameDecoder.hasFlag(by, (byte)1);
                    by = SpdyFrameDecoder.hasFlag(by, (byte)2) ? 1 : 0;
                    byteBuf.skipBytes(8);
                    --this.numSettings;
                    this.delegate.readSetting(n6, by2, n4 != 0, by != 0);
                    continue block16;
                }
                case READ_PING_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    ByteBuf byteBuf9 = byteBuf;
                    int by = SpdyCodecUtil.getSignedInt(byteBuf9, byteBuf9.readerIndex());
                    byteBuf.skipBytes(4);
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readPingFrame(by);
                    continue block16;
                }
                case READ_GOAWAY_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf10 = byteBuf;
                    int n7 = SpdyCodecUtil.getUnsignedInt(byteBuf10, byteBuf10.readerIndex());
                    ByteBuf byteBuf11 = byteBuf;
                    int by = SpdyCodecUtil.getSignedInt(byteBuf11, byteBuf11.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readGoAwayFrame(n7, by);
                    continue block16;
                }
                case READ_HEADERS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    ByteBuf byteBuf12 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf12, byteBuf12.readerIndex());
                    int by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid HEADERS Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readHeadersFrame(this.streamId, by != 0);
                    continue block16;
                }
                case READ_WINDOW_UPDATE_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf13 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf13, byteBuf13.readerIndex());
                    ByteBuf byteBuf14 = byteBuf;
                    int by = SpdyCodecUtil.getUnsignedInt(byteBuf14, byteBuf14.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (by == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid WINDOW_UPDATE Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readWindowUpdateFrame(this.streamId, by);
                    continue block16;
                }
                case READ_HEADER_BLOCK: {
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readHeaderBlockEnd();
                        continue block16;
                    }
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    int by = Math.min(byteBuf.readableBytes(), this.length);
                    ByteBuf byteBuf16 = byteBuf.alloc().buffer(by);
                    byteBuf16.writeBytes(byteBuf, by);
                    this.length -= by;
                    this.delegate.readHeaderBlock(byteBuf16);
                    continue block16;
                }
                case DISCARD_FRAME: {
                    int by = Math.min(byteBuf.readableBytes(), this.length);
                    byteBuf.skipBytes(by);
                    this.length -= by;
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        continue block16;
                    }
                    return;
                }
                case FRAME_ERROR: {
                    ByteBuf byteBuf15 = byteBuf;
                    byteBuf15.skipBytes(byteBuf15.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new Error("Shouldn't reach here.");
    }

    private static boolean hasFlag(byte by, byte by2) {
        return (by & by2) != 0;
    }

    private static SpdyFrameDecoder$State getNextState(int n2, int n3) {
        switch (n2) {
            case 0: {
                return SpdyFrameDecoder$State.READ_DATA_FRAME;
            }
            case 1: {
                return SpdyFrameDecoder$State.READ_SYN_STREAM_FRAME;
            }
            case 2: {
                return SpdyFrameDecoder$State.READ_SYN_REPLY_FRAME;
            }
            case 3: {
                return SpdyFrameDecoder$State.READ_RST_STREAM_FRAME;
            }
            case 4: {
                return SpdyFrameDecoder$State.READ_SETTINGS_FRAME;
            }
            case 6: {
                return SpdyFrameDecoder$State.READ_PING_FRAME;
            }
            case 7: {
                return SpdyFrameDecoder$State.READ_GOAWAY_FRAME;
            }
            case 8: {
                return SpdyFrameDecoder$State.READ_HEADERS_FRAME;
            }
            case 9: {
                return SpdyFrameDecoder$State.READ_WINDOW_UPDATE_FRAME;
            }
        }
        if (n3 != 0) {
            return SpdyFrameDecoder$State.DISCARD_FRAME;
        }
        return SpdyFrameDecoder$State.READ_COMMON_HEADER;
    }

    private static boolean isValidFrameHeader(int n2, int n3, byte by, int n4) {
        switch (n3) {
            case 0: {
                return n2 != 0;
            }
            case 1: {
                return n4 >= 10;
            }
            case 2: {
                return n4 >= 4;
            }
            case 3: {
                return by == 0 && n4 == 8;
            }
            case 4: {
                return n4 >= 4;
            }
            case 6: {
                return n4 == 4;
            }
            case 7: {
                return n4 == 8;
            }
            case 8: {
                return n4 >= 4;
            }
            case 9: {
                return n4 == 8;
            }
        }
        return true;
    }
}

