/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySettingsFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import java.nio.ByteOrder;

public class SpdyFrameEncoder {
    private final int version;

    public SpdyFrameEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        this.version = spdyVersion.getVersion();
    }

    private void writeControlFrameHeader(ByteBuf byteBuf, int n2, byte by, int n3) {
        byteBuf.writeShort(this.version | 0x8000);
        byteBuf.writeShort(n2);
        byteBuf.writeByte(by);
        byteBuf.writeMedium(n3);
    }

    public ByteBuf encodeDataFrame(ByteBufAllocator object, int n2, boolean bl, ByteBuf byteBuf) {
        bl = bl;
        int n3 = byteBuf.readableBytes();
        object = object.ioBuffer(n3 + 8).order(ByteOrder.BIG_ENDIAN);
        ((ByteBuf)object).writeInt(n2 & Integer.MAX_VALUE);
        ((ByteBuf)object).writeByte(bl ? 1 : 0);
        ((ByteBuf)object).writeMedium(n3);
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)object).writeBytes(byteBuf2, byteBuf2.readerIndex(), n3);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeSynStreamFrame(ByteBufAllocator object, int n2, int n3, byte by, boolean bl, boolean bl2, ByteBuf byteBuf) {
        byte by2;
        void var6_8;
        int n4;
        void var7_10;
        int n5 = var7_10.readableBytes();
        int n6 = n4 = bl ? 1 : 0;
        if (var6_8 != false) {
            by2 = (byte)(n4 | 2);
        }
        int n7 = n5 + 10;
        object = object.ioBuffer(n7 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 1, by2, n7);
        ((ByteBuf)object).writeInt(n2);
        ((ByteBuf)object).writeInt(n3);
        ((ByteBuf)object).writeShort((by & 0xFF) << 13);
        void v1 = var7_10;
        ((ByteBuf)object).writeBytes((ByteBuf)v1, v1.readerIndex(), n5);
        return object;
    }

    public ByteBuf encodeSynReplyFrame(ByteBufAllocator object, int n2, boolean bl, ByteBuf byteBuf) {
        int n3 = byteBuf.readableBytes();
        bl = bl;
        int n4 = n3 + 4;
        object = object.ioBuffer(n4 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 2, (byte)(bl ? 1 : 0), n4);
        ((ByteBuf)object).writeInt(n2);
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)object).writeBytes(byteBuf2, byteBuf2.readerIndex(), n3);
        return object;
    }

    public ByteBuf encodeRstStreamFrame(ByteBufAllocator object, int n2, int n3) {
        object = object.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 3, (byte)0, 8);
        ((ByteBuf)object).writeInt(n2);
        ((ByteBuf)object).writeInt(n3);
        return object;
    }

    public ByteBuf encodeSettingsFrame(ByteBufAllocator object, SpdySettingsFrame spdySettingsFrame) {
        Object object2 = spdySettingsFrame.ids();
        int n2 = object2.size();
        byte by = spdySettingsFrame.clearPreviouslyPersistedSettings() ? (byte)1 : 0;
        int n3 = 4 + n2 * 8;
        object = object.ioBuffer(n3 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 4, by, n3);
        ((ByteBuf)object).writeInt(n2);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Integer n4 = (Integer)object2.next();
            by = 0;
            if (spdySettingsFrame.isPersistValue(n4)) {
                by = 1;
            }
            if (spdySettingsFrame.isPersisted(n4)) {
                by = (byte)(by | 2);
            }
            ((ByteBuf)object).writeByte(by);
            ((ByteBuf)object).writeMedium(n4);
            ((ByteBuf)object).writeInt(spdySettingsFrame.getValue(n4));
        }
        return object;
    }

    public ByteBuf encodePingFrame(ByteBufAllocator object, int n2) {
        object = object.ioBuffer(12).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 6, (byte)0, 4);
        ((ByteBuf)object).writeInt(n2);
        return object;
    }

    public ByteBuf encodeGoAwayFrame(ByteBufAllocator object, int n2, int n3) {
        object = object.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 7, (byte)0, 8);
        ((ByteBuf)object).writeInt(n2);
        ((ByteBuf)object).writeInt(n3);
        return object;
    }

    public ByteBuf encodeHeadersFrame(ByteBufAllocator object, int n2, boolean bl, ByteBuf byteBuf) {
        int n3 = byteBuf.readableBytes();
        bl = bl;
        int n4 = n3 + 4;
        object = object.ioBuffer(n4 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 8, (byte)(bl ? 1 : 0), n4);
        ((ByteBuf)object).writeInt(n2);
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)object).writeBytes(byteBuf2, byteBuf2.readerIndex(), n3);
        return object;
    }

    public ByteBuf encodeWindowUpdateFrame(ByteBufAllocator object, int n2, int n3) {
        object = object.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)object, 9, (byte)0, 8);
        ((ByteBuf)object).writeInt(n2);
        ((ByteBuf)object).writeInt(n3);
        return object;
    }
}

