/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.CompressionException;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyCodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.JZlib;

class SpdyHeaderBlockJZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater z = new Deflater();
    private boolean finished;

    SpdyHeaderBlockJZlibEncoder(SpdyVersion spdyVersion, int n2, int n3, int n4) {
        super(spdyVersion);
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (n3 < 9 || n3 > 15) {
            throw new IllegalArgumentException("windowBits: " + n3 + " (expected: 9-15)");
        }
        if (n4 <= 0 || n4 > 9) {
            throw new IllegalArgumentException("memLevel: " + n4 + " (expected: 1-9)");
        }
        int n5 = this.z.deflateInit(n2, n3, n4, JZlib.W_ZLIB);
        if (n5 != 0) {
            throw new CompressionException("failed to initialize an SPDY header block deflater: " + n5);
        }
        n5 = this.z.deflateSetDictionary(SpdyCodecUtil.SPDY_DICT, SpdyCodecUtil.SPDY_DICT.length);
        if (n5 != 0) {
            throw new CompressionException("failed to set the SPDY dictionary: " + n5);
        }
    }

    private void setInput(ByteBuf byteBuf) {
        int n2;
        byte[] byArray;
        int n3 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n2 = byteBuf.arrayOffset() + byteBuf.readerIndex();
        } else {
            byArray = new byte[n3];
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.getBytes(byteBuf2.readerIndex(), byArray);
            n2 = 0;
        }
        this.z.next_in = byArray;
        this.z.next_in_index = n2;
        this.z.avail_in = n3;
    }

    private ByteBuf encode(ByteBufAllocator byteBufAllocator) {
        boolean bl = true;
        ReferenceCounted referenceCounted = null;
        try {
            int n2;
            int n3 = this.z.next_in_index;
            int n4 = this.z.next_out_index;
            int n5 = (int)Math.ceil((double)this.z.next_in.length * 1.001) + 12;
            referenceCounted = byteBufAllocator.heapBuffer(n5);
            this.z.next_out = ((ByteBuf)referenceCounted).array();
            this.z.next_out_index = ((ByteBuf)referenceCounted).arrayOffset() + ((ByteBuf)referenceCounted).writerIndex();
            this.z.avail_out = n5;
            try {
                n2 = this.z.deflate(2);
            }
            finally {
                ((ByteBuf)referenceCounted).skipBytes(this.z.next_in_index - n3);
            }
            if (n2 != 0) {
                throw new CompressionException("compression failure: " + n2);
            }
            n2 = this.z.next_out_index - n4;
            if (n2 > 0) {
                ReferenceCounted referenceCounted2 = referenceCounted;
                ((ByteBuf)referenceCounted2).writerIndex(((ByteBuf)referenceCounted2).writerIndex() + n2);
            }
            bl = false;
            ReferenceCounted referenceCounted3 = referenceCounted;
            this.z.next_in = null;
            this.z.next_out = null;
            return referenceCounted3;
        }
        catch (Throwable throwable) {
            this.z.next_in = null;
            this.z.next_out = null;
            if (bl && referenceCounted != null) {
                referenceCounted.release();
            }
            throw throwable;
        }
    }

    @Override
    public ByteBuf encode(ByteBufAllocator object, SpdyHeadersFrame object2) {
        if (object2 == null) {
            throw new IllegalArgumentException("frame");
        }
        if (this.finished) {
            return Unpooled.EMPTY_BUFFER;
        }
        object2 = super.encode((ByteBufAllocator)object, (SpdyHeadersFrame)object2);
        try {
            if (!((ByteBuf)object2).isReadable()) {
                object = Unpooled.EMPTY_BUFFER;
                return object;
            }
            this.setInput((ByteBuf)object2);
            object = this.encode((ByteBufAllocator)object);
            return object;
        }
        finally {
            object2.release();
        }
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.z.deflateEnd();
        this.z.next_in = null;
        this.z.next_out = null;
    }
}

