/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyCodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockRawDecoder$State;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;

public class SpdyHeaderBlockRawDecoder
extends SpdyHeaderBlockDecoder {
    private static final int LENGTH_FIELD_SIZE = 4;
    private final int maxHeaderSize;
    private SpdyHeaderBlockRawDecoder$State state;
    private ByteBuf cumulation;
    private int headerSize;
    private int numHeaders;
    private int length;
    private String name;

    public SpdyHeaderBlockRawDecoder(SpdyVersion spdyVersion, int n2) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        this.maxHeaderSize = n2;
        this.state = SpdyHeaderBlockRawDecoder$State.READ_NUM_HEADERS;
    }

    private static int readLengthField(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        int n2 = SpdyCodecUtil.getSignedInt(byteBuf2, byteBuf2.readerIndex());
        byteBuf.skipBytes(4);
        return n2;
    }

    @Override
    void decode(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, SpdyHeadersFrame spdyHeadersFrame) {
        if (byteBuf == null) {
            throw new NullPointerException("headerBlock");
        }
        if (spdyHeadersFrame == null) {
            throw new NullPointerException("frame");
        }
        if (this.cumulation == null) {
            this.decodeHeaderBlock(byteBuf, spdyHeadersFrame);
            if (byteBuf.isReadable()) {
                this.cumulation = byteBufAllocator.buffer(byteBuf.readableBytes());
                this.cumulation.writeBytes(byteBuf);
                return;
            }
        } else {
            this.cumulation.writeBytes(byteBuf);
            SpdyHeaderBlockRawDecoder spdyHeaderBlockRawDecoder = this;
            spdyHeaderBlockRawDecoder.decodeHeaderBlock(spdyHeaderBlockRawDecoder.cumulation, spdyHeadersFrame);
            if (this.cumulation.isReadable()) {
                this.cumulation.discardReadBytes();
                return;
            }
            this.releaseBuffer();
        }
    }

    protected void decodeHeaderBlock(ByteBuf byteBuf, SpdyHeadersFrame spdyHeadersFrame) {
        block13: while (byteBuf.isReadable()) {
            switch (this.state) {
                case READ_NUM_HEADERS: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.numHeaders = SpdyHeaderBlockRawDecoder.readLengthField(byteBuf);
                    if (this.numHeaders < 0) {
                        this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                        spdyHeadersFrame.setInvalid();
                        continue block13;
                    }
                    if (this.numHeaders == 0) {
                        this.state = SpdyHeaderBlockRawDecoder$State.END_HEADER_BLOCK;
                        continue block13;
                    }
                    this.state = SpdyHeaderBlockRawDecoder$State.READ_NAME_LENGTH;
                    continue block13;
                }
                case READ_NAME_LENGTH: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.length = SpdyHeaderBlockRawDecoder.readLengthField(byteBuf);
                    if (this.length <= 0) {
                        this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                        spdyHeadersFrame.setInvalid();
                        continue block13;
                    }
                    if (this.length > this.maxHeaderSize || this.headerSize > this.maxHeaderSize - this.length) {
                        this.headerSize = this.maxHeaderSize + 1;
                        this.state = SpdyHeaderBlockRawDecoder$State.SKIP_NAME;
                        spdyHeadersFrame.setTruncated();
                        continue block13;
                    }
                    this.headerSize += this.length;
                    this.state = SpdyHeaderBlockRawDecoder$State.READ_NAME;
                    continue block13;
                }
                case READ_NAME: {
                    if (byteBuf.readableBytes() < this.length) {
                        return;
                    }
                    byte[] byArray = new byte[this.length];
                    byteBuf.readBytes(byArray);
                    this.name = new String(byArray, "UTF-8");
                    if (spdyHeadersFrame.headers().contains(this.name)) {
                        this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                        spdyHeadersFrame.setInvalid();
                        continue block13;
                    }
                    this.state = SpdyHeaderBlockRawDecoder$State.READ_VALUE_LENGTH;
                    continue block13;
                }
                case SKIP_NAME: {
                    int n2 = Math.min(byteBuf.readableBytes(), this.length);
                    byteBuf.skipBytes(n2);
                    this.length -= n2;
                    if (this.length != 0) continue block13;
                    this.state = SpdyHeaderBlockRawDecoder$State.READ_VALUE_LENGTH;
                    continue block13;
                }
                case READ_VALUE_LENGTH: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.length = SpdyHeaderBlockRawDecoder.readLengthField(byteBuf);
                    if (this.length < 0) {
                        this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                        spdyHeadersFrame.setInvalid();
                        continue block13;
                    }
                    if (this.length == 0) {
                        if (!spdyHeadersFrame.isTruncated()) {
                            spdyHeadersFrame.headers().add(this.name, "");
                        }
                        this.name = null;
                        if (--this.numHeaders == 0) {
                            this.state = SpdyHeaderBlockRawDecoder$State.END_HEADER_BLOCK;
                            continue block13;
                        }
                        this.state = SpdyHeaderBlockRawDecoder$State.READ_NAME_LENGTH;
                        continue block13;
                    }
                    if (this.length > this.maxHeaderSize || this.headerSize > this.maxHeaderSize - this.length) {
                        this.headerSize = this.maxHeaderSize + 1;
                        this.name = null;
                        this.state = SpdyHeaderBlockRawDecoder$State.SKIP_VALUE;
                        spdyHeadersFrame.setTruncated();
                        continue block13;
                    }
                    this.headerSize += this.length;
                    this.state = SpdyHeaderBlockRawDecoder$State.READ_VALUE;
                    continue block13;
                }
                case READ_VALUE: {
                    if (byteBuf.readableBytes() < this.length) {
                        return;
                    }
                    byte[] byArray = new byte[this.length];
                    byteBuf.readBytes(byArray);
                    int n3 = 0;
                    int n4 = 0;
                    if (byArray[0] == 0) {
                        this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                        spdyHeadersFrame.setInvalid();
                        continue block13;
                    }
                    while (n3 < this.length) {
                        while (n3 < byArray.length && byArray[n3] != 0) {
                            ++n3;
                        }
                        if (n3 < byArray.length && (n3 + 1 == byArray.length || byArray[n3 + 1] == 0)) {
                            this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                            spdyHeadersFrame.setInvalid();
                            break;
                        }
                        String string = new String(byArray, n4, n3 - n4, "UTF-8");
                        try {
                            spdyHeadersFrame.headers().add(this.name, string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                            spdyHeadersFrame.setInvalid();
                            break;
                        }
                        n4 = ++n3;
                    }
                    this.name = null;
                    if (this.state == SpdyHeaderBlockRawDecoder$State.ERROR) continue block13;
                    if (--this.numHeaders == 0) {
                        this.state = SpdyHeaderBlockRawDecoder$State.END_HEADER_BLOCK;
                        continue block13;
                    }
                    this.state = SpdyHeaderBlockRawDecoder$State.READ_NAME_LENGTH;
                    continue block13;
                }
                case SKIP_VALUE: {
                    int n5 = Math.min(byteBuf.readableBytes(), this.length);
                    byteBuf.skipBytes(n5);
                    this.length -= n5;
                    if (this.length != 0) continue block13;
                    if (--this.numHeaders == 0) {
                        this.state = SpdyHeaderBlockRawDecoder$State.END_HEADER_BLOCK;
                        continue block13;
                    }
                    this.state = SpdyHeaderBlockRawDecoder$State.READ_NAME_LENGTH;
                    continue block13;
                }
                case END_HEADER_BLOCK: {
                    this.state = SpdyHeaderBlockRawDecoder$State.ERROR;
                    spdyHeadersFrame.setInvalid();
                    continue block13;
                }
                case ERROR: {
                    ByteBuf byteBuf2 = byteBuf;
                    byteBuf2.skipBytes(byteBuf2.readableBytes());
                    return;
                }
            }
            throw new Error("Shouldn't reach here.");
        }
    }

    @Override
    void endHeaderBlock(SpdyHeadersFrame spdyHeadersFrame) {
        if (this.state != SpdyHeaderBlockRawDecoder$State.END_HEADER_BLOCK) {
            spdyHeadersFrame.setInvalid();
        }
        this.releaseBuffer();
        this.headerSize = 0;
        this.name = null;
        this.state = SpdyHeaderBlockRawDecoder$State.READ_NUM_HEADERS;
    }

    @Override
    void end() {
        this.releaseBuffer();
    }

    private void releaseBuffer() {
        if (this.cumulation != null) {
            this.cumulation.release();
            this.cumulation = null;
        }
    }
}

