/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import java.util.Set;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        this.version = spdyVersion.getVersion();
    }

    private static void setLengthField(ByteBuf byteBuf, int n2, int n3) {
        byteBuf.setInt(n2, n3);
    }

    private static void writeLengthField(ByteBuf byteBuf, int n2) {
        byteBuf.writeInt(n2);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator object, SpdyHeadersFrame spdyHeadersFrame) {
        Set<String> set = spdyHeadersFrame.headers().names();
        int n2 = set.size();
        if (n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (n2 > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        object = object.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField((ByteBuf)object, n2);
        for (String string : set) {
            byte[] byArray = string.getBytes("UTF-8");
            SpdyHeaderBlockRawEncoder.writeLengthField((ByteBuf)object, byArray.length);
            ((ByteBuf)object).writeBytes(byArray);
            int n3 = ((ByteBuf)object).writerIndex();
            int n4 = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField((ByteBuf)object, 0);
            for (String string2 : spdyHeadersFrame.headers().getAll(string)) {
                byte[] object2 = string2.getBytes("UTF-8");
                if (object2.length <= 0) continue;
                ((ByteBuf)object).writeBytes(object2);
                ((ByteBuf)object).writeByte(0);
                n4 += object2.length + 1;
            }
            if (n4 != 0) {
                --n4;
            }
            if (n4 > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + string);
            }
            if (n4 <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField((ByteBuf)object, n3, n4);
            Object object2 = object;
            ((ByteBuf)object2).writerIndex(((ByteBuf)object2).writerIndex() - 1);
        }
        return object;
    }

    @Override
    void end() {
    }
}

