/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyCodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockRawDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyProtocolException;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class SpdyHeaderBlockZlibDecoder
extends SpdyHeaderBlockRawDecoder {
    private static final int DEFAULT_BUFFER_CAPACITY = 4096;
    private static final SpdyProtocolException INVALID_HEADER_BLOCK = new SpdyProtocolException("Invalid Header Block");
    private final Inflater decompressor = new Inflater();
    private ByteBuf decompressed;

    SpdyHeaderBlockZlibDecoder(SpdyVersion spdyVersion, int n2) {
        super(spdyVersion, n2);
    }

    @Override
    final void decode(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, SpdyHeadersFrame spdyHeadersFrame) {
        int n2;
        int n3 = this.setInput(byteBuf);
        while ((n2 = this.decompress(byteBufAllocator, spdyHeadersFrame)) > 0) {
        }
        if (this.decompressor.getRemaining() != 0) {
            throw INVALID_HEADER_BLOCK;
        }
        byteBuf.skipBytes(n3);
    }

    private int setInput(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            this.decompressor.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n2);
        } else {
            byte[] byArray = new byte[n2];
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.getBytes(byteBuf2.readerIndex(), byArray);
            this.decompressor.setInput(byArray, 0, byArray.length);
        }
        return n2;
    }

    private int decompress(ByteBufAllocator object, SpdyHeadersFrame spdyHeadersFrame) {
        this.ensureBuffer((ByteBufAllocator)object);
        object = this.decompressed.array();
        int n2 = this.decompressed.arrayOffset() + this.decompressed.writerIndex();
        try {
            int n3 = this.decompressor.inflate((byte[])object, n2, this.decompressed.writableBytes());
            if (n3 == 0 && this.decompressor.needsDictionary()) {
                try {
                    this.decompressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw INVALID_HEADER_BLOCK;
                }
                n3 = this.decompressor.inflate((byte[])object, n2, this.decompressed.writableBytes());
            }
            if (spdyHeadersFrame != null) {
                this.decompressed.writerIndex(this.decompressed.writerIndex() + n3);
                SpdyHeaderBlockZlibDecoder spdyHeaderBlockZlibDecoder = this;
                spdyHeaderBlockZlibDecoder.decodeHeaderBlock(spdyHeaderBlockZlibDecoder.decompressed, spdyHeadersFrame);
                this.decompressed.discardReadBytes();
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            throw new SpdyProtocolException("Received invalid header block", dataFormatException);
        }
    }

    private void ensureBuffer(ByteBufAllocator byteBufAllocator) {
        if (this.decompressed == null) {
            this.decompressed = byteBufAllocator.heapBuffer(4096);
        }
        this.decompressed.ensureWritable(1);
    }

    @Override
    final void endHeaderBlock(SpdyHeadersFrame spdyHeadersFrame) {
        super.endHeaderBlock(spdyHeadersFrame);
        this.releaseBuffer();
    }

    @Override
    public final void end() {
        super.end();
        this.releaseBuffer();
        this.decompressor.end();
    }

    private void releaseBuffer() {
        if (this.decompressed != null) {
            this.decompressed.release();
            this.decompressed = null;
        }
    }
}

