/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyCodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import java.util.zip.Deflater;

class SpdyHeaderBlockZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater compressor;
    private boolean finished;

    SpdyHeaderBlockZlibEncoder(SpdyVersion spdyVersion, int n2) {
        super(spdyVersion);
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        this.compressor = new Deflater(n2);
        this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
    }

    private int setInput(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            this.compressor.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n2);
        } else {
            byte[] byArray = new byte[n2];
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.getBytes(byteBuf2.readerIndex(), byArray);
            this.compressor.setInput(byArray, 0, byArray.length);
        }
        return n2;
    }

    private ByteBuf encode(ByteBufAllocator object, int n2) {
        object = object.heapBuffer(n2);
        n2 = 1;
        try {
            while (this.compressInto((ByteBuf)object)) {
                Object object2 = object;
                ((ByteBuf)object2).ensureWritable(((ByteBuf)object2).capacity() << 1);
            }
            n2 = 0;
            Object object3 = object;
            return object3;
        }
        catch (Throwable throwable) {
            if (n2 != 0) {
                object.release();
            }
            throw throwable;
        }
    }

    private boolean compressInto(ByteBuf byteBuf) {
        byte[] byArray = byteBuf.array();
        int n2 = byteBuf.arrayOffset() + byteBuf.writerIndex();
        int n3 = byteBuf.writableBytes();
        int n4 = this.compressor.deflate(byArray, n2, n3, 2);
        ByteBuf byteBuf2 = byteBuf;
        byteBuf2.writerIndex(byteBuf2.writerIndex() + n4);
        return n4 == n3;
    }

    @Override
    public ByteBuf encode(ByteBufAllocator object, SpdyHeadersFrame object2) {
        if (object2 == null) {
            throw new IllegalArgumentException("frame");
        }
        if (this.finished) {
            return Unpooled.EMPTY_BUFFER;
        }
        object2 = super.encode((ByteBufAllocator)object, (SpdyHeadersFrame)object2);
        try {
            if (!((ByteBuf)object2).isReadable()) {
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            int n2 = this.setInput((ByteBuf)object2);
            object = this.encode((ByteBufAllocator)object, n2);
            return object;
        }
        finally {
            object2.release();
        }
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.compressor.end();
        super.end();
    }
}

