/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyCodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyDataFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyStreamStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySynReplyFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySynStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpdyHttpDecoder
extends MessageToMessageDecoder<SpdyFrame> {
    private final boolean validateHeaders;
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, FullHttpMessage> messageMap;

    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n2) {
        this(spdyVersion, n2, new HashMap<Integer, FullHttpMessage>(), true);
    }

    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n2, boolean bl) {
        this(spdyVersion, n2, new HashMap<Integer, FullHttpMessage>(), bl);
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n2, Map<Integer, FullHttpMessage> map) {
        this(spdyVersion, n2, map, true);
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n2, Map<Integer, FullHttpMessage> map, boolean bl) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + n2);
        }
        this.spdyVersion = spdyVersion.getVersion();
        this.maxContentLength = n2;
        this.messageMap = map;
        this.validateHeaders = bl;
    }

    protected FullHttpMessage putMessage(int n2, FullHttpMessage fullHttpMessage) {
        return this.messageMap.put(n2, fullHttpMessage);
    }

    protected FullHttpMessage getMessage(int n2) {
        return this.messageMap.get(n2);
    }

    protected FullHttpMessage removeMessage(int n2) {
        return this.messageMap.remove(n2);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, SpdyFrame spdyFrame, List<Object> list) {
        block32: {
            if (spdyFrame instanceof SpdySynStreamFrame) {
                block31: {
                    int n2 = (spdyFrame = (SpdySynStreamFrame)spdyFrame).streamId();
                    if (SpdyCodecUtil.isServerId(n2)) {
                        int n3 = spdyFrame.associatedStreamId();
                        if (n3 == 0) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n2, SpdyStreamStatus.INVALID_STREAM);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                            return;
                        }
                        if (spdyFrame.isLast()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n2, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                            return;
                        }
                        if (spdyFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n2, SpdyStreamStatus.INTERNAL_ERROR);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                            return;
                        }
                        try {
                            FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest(this.spdyVersion, (SpdyHeadersFrame)spdyFrame);
                            SpdyHttpHeaders.setStreamId(fullHttpRequest, n2);
                            SpdyHttpHeaders.setAssociatedToStreamId(fullHttpRequest, n3);
                            SpdyHttpHeaders.setPriority(fullHttpRequest, spdyFrame.priority());
                            list.add(fullHttpRequest);
                            break block31;
                        }
                        catch (Exception exception) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n2, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                            break block32;
                        }
                    }
                    if (spdyFrame.isTruncated()) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n2);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders.setStatus(this.spdyVersion, defaultSpdySynReplyFrame, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                        SpdyHeaders.setVersion(this.spdyVersion, defaultSpdySynReplyFrame, HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush(defaultSpdySynReplyFrame);
                        return;
                    }
                    try {
                        FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest(this.spdyVersion, (SpdyHeadersFrame)spdyFrame);
                        SpdyHttpHeaders.setStreamId(fullHttpRequest, n2);
                        if (spdyFrame.isLast()) {
                            list.add(fullHttpRequest);
                            break block31;
                        }
                        this.putMessage(n2, fullHttpRequest);
                        break block32;
                    }
                    catch (Exception exception) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n2);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders.setStatus(this.spdyVersion, defaultSpdySynReplyFrame, HttpResponseStatus.BAD_REQUEST);
                        SpdyHeaders.setVersion(this.spdyVersion, defaultSpdySynReplyFrame, HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush(defaultSpdySynReplyFrame);
                    }
                }
                return;
            }
            if (spdyFrame instanceof SpdySynReplyFrame) {
                block33: {
                    spdyFrame = (SpdySynReplyFrame)spdyFrame;
                    int n4 = spdyFrame.streamId();
                    if (spdyFrame.isTruncated()) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, SpdyStreamStatus.INTERNAL_ERROR);
                        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                        return;
                    }
                    try {
                        FullHttpResponse fullHttpResponse = SpdyHttpDecoder.createHttpResponse(channelHandlerContext, this.spdyVersion, (SpdyHeadersFrame)spdyFrame, this.validateHeaders);
                        SpdyHttpHeaders.setStreamId(fullHttpResponse, n4);
                        if (spdyFrame.isLast()) {
                            HttpHeaders.setContentLength(fullHttpResponse, 0L);
                            list.add(fullHttpResponse);
                            break block33;
                        }
                        this.putMessage(n4, fullHttpResponse);
                        break block32;
                    }
                    catch (Exception exception) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, SpdyStreamStatus.PROTOCOL_ERROR);
                        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                    }
                }
                return;
            }
            if (spdyFrame instanceof SpdyHeadersFrame) {
                int n5 = (spdyFrame = (SpdyHeadersFrame)spdyFrame).streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n5);
                if (fullHttpMessage == null) {
                    if (SpdyCodecUtil.isServerId(n5)) {
                        if (spdyFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n5, SpdyStreamStatus.INTERNAL_ERROR);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                            return;
                        }
                        try {
                            fullHttpMessage = SpdyHttpDecoder.createHttpResponse(channelHandlerContext, this.spdyVersion, (SpdyHeadersFrame)spdyFrame, this.validateHeaders);
                            SpdyHttpHeaders.setStreamId(fullHttpMessage, n5);
                            if (!spdyFrame.isLast()) {
                                this.putMessage(n5, fullHttpMessage);
                                return;
                            }
                            HttpHeaders.setContentLength(fullHttpMessage, 0L);
                            list.add(fullHttpMessage);
                        }
                        catch (Exception exception) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n5, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                        }
                    }
                    return;
                }
                if (!spdyFrame.isTruncated()) {
                    for (Map.Entry<String, String> entry : spdyFrame.headers()) {
                        fullHttpMessage.headers().add(entry.getKey(), (Object)entry.getValue());
                    }
                }
                if (spdyFrame.isLast()) {
                    FullHttpMessage fullHttpMessage2 = fullHttpMessage;
                    HttpHeaders.setContentLength(fullHttpMessage2, fullHttpMessage2.content().readableBytes());
                    this.removeMessage(n5);
                    list.add(fullHttpMessage);
                }
                return;
            }
            if (spdyFrame instanceof SpdyDataFrame) {
                int n6 = (spdyFrame = (SpdyDataFrame)spdyFrame).streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n6);
                if (fullHttpMessage == null) {
                    return;
                }
                ByteBuf byteBuf = fullHttpMessage.content();
                if (byteBuf.readableBytes() > this.maxContentLength - spdyFrame.content().readableBytes()) {
                    this.removeMessage(n6);
                    throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
                }
                ByteBuf byteBuf2 = spdyFrame.content();
                int n7 = byteBuf2.readableBytes();
                ByteBuf byteBuf3 = byteBuf2;
                byteBuf.writeBytes(byteBuf3, byteBuf3.readerIndex(), n7);
                if (spdyFrame.isLast()) {
                    HttpHeaders.setContentLength(fullHttpMessage, byteBuf.readableBytes());
                    this.removeMessage(n6);
                    list.add(fullHttpMessage);
                }
                return;
            }
            if (spdyFrame instanceof SpdyRstStreamFrame) {
                spdyFrame = (SpdyRstStreamFrame)spdyFrame;
                int n8 = spdyFrame.streamId();
                this.removeMessage(n8);
            }
        }
    }

    private static FullHttpRequest createHttpRequest(int n2, SpdyHeadersFrame object3) {
        SpdyHeaders spdyHeaders = object3.headers();
        Object object2 = SpdyHeaders.getMethod(n2, (SpdyHeadersFrame)object3);
        String string = SpdyHeaders.getUrl(n2, (SpdyHeadersFrame)object3);
        HttpVersion httpVersion = SpdyHeaders.getVersion(n2, (SpdyHeadersFrame)object3);
        SpdyHeaders.removeMethod(n2, (SpdyHeadersFrame)object3);
        SpdyHeaders.removeUrl(n2, (SpdyHeadersFrame)object3);
        SpdyHeaders.removeVersion(n2, (SpdyHeadersFrame)object3);
        object2 = new DefaultFullHttpRequest(httpVersion, (HttpMethod)object2, string);
        SpdyHeaders.removeScheme(n2, (SpdyHeadersFrame)object3);
        String string2 = spdyHeaders.get(":host");
        spdyHeaders.remove(":host");
        object2.headers().set("Host", (Object)string2);
        for (Object object3 : object3.headers()) {
            object2.headers().add((String)object3.getKey(), object3.getValue());
        }
        HttpHeaders.setKeepAlive((HttpMessage)object2, true);
        object2.headers().remove("Transfer-Encoding");
        return object2;
    }

    private static FullHttpResponse createHttpResponse(ChannelHandlerContext object, int n2, SpdyHeadersFrame object22, boolean bl) {
        HttpResponseStatus httpResponseStatus = SpdyHeaders.getStatus(n2, (SpdyHeadersFrame)object22);
        HttpVersion httpVersion = SpdyHeaders.getVersion(n2, (SpdyHeadersFrame)object22);
        SpdyHeaders.removeStatus(n2, (SpdyHeadersFrame)object22);
        SpdyHeaders.removeVersion(n2, (SpdyHeadersFrame)object22);
        object = new DefaultFullHttpResponse(httpVersion, httpResponseStatus, object.alloc().buffer(), bl);
        for (Object object22 : object22.headers()) {
            object.headers().add((String)object22.getKey(), object22.getValue());
        }
        HttpHeaders.setKeepAlive((HttpMessage)object, true);
        object.headers().remove("Transfer-Encoding");
        object.headers().remove("Trailer");
        return object;
    }
}

