/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.UnsupportedMessageTypeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObject;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyCodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySynStreamFrame;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpEncoder
extends MessageToMessageEncoder<HttpObject> {
    private int currentStreamId;

    public SpdyHttpEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        boolean bl = false;
        boolean bl2 = false;
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpRequest);
            list.add(spdySynStreamFrame);
            bl2 = spdySynStreamFrame.isLast() || spdySynStreamFrame.isUnidirectional();
            bl = true;
        }
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            SpdyHeadersFrame spdyHeadersFrame = this.createHeadersFrame(httpResponse);
            list.add(spdyHeadersFrame);
            bl2 = spdyHeadersFrame.isLast();
            bl = true;
        }
        if (httpObject instanceof HttpContent && !bl2) {
            Iterator iterator = (HttpContent)httpObject;
            iterator.content().retain();
            DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(this.currentStreamId, iterator.content());
            if (iterator instanceof LastHttpContent) {
                iterator = (LastHttpContent)((Object)iterator);
                if (((HttpHeaders)((Object)(iterator = iterator.trailingHeaders()))).isEmpty()) {
                    defaultSpdyDataFrame.setLast(true);
                    list.add(defaultSpdyDataFrame);
                } else {
                    DefaultSpdyHeadersFrame defaultSpdyHeadersFrame = new DefaultSpdyHeadersFrame(this.currentStreamId);
                    defaultSpdyHeadersFrame.setLast(true);
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        defaultSpdyHeadersFrame.headers().add((String)entry.getKey(), entry.getValue());
                    }
                    list.add(defaultSpdyDataFrame);
                    list.add(defaultSpdyHeadersFrame);
                }
            } else {
                list.add(defaultSpdyDataFrame);
            }
            bl = true;
        }
        if (!bl) {
            throw new UnsupportedMessageTypeException(httpObject, new Class[0]);
        }
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpRequest httpRequest) {
        Object object = httpRequest.headers();
        int n2 = SpdyHttpHeaders.getStreamId(httpRequest);
        int n3 = SpdyHttpHeaders.getAssociatedToStreamId(httpRequest);
        byte by = SpdyHttpHeaders.getPriority(httpRequest);
        Object object2 = ((HttpHeaders)object).get("x-spdy-scheme");
        ((HttpHeaders)object).remove("x-spdy-stream-id");
        ((HttpHeaders)object).remove("x-spdy-associated-to-stream-id");
        ((HttpHeaders)object).remove("x-spdy-priority");
        ((HttpHeaders)object).remove("x-spdy-scheme");
        ((HttpHeaders)object).remove("Connection");
        ((HttpHeaders)object).remove("Keep-Alive");
        ((HttpHeaders)object).remove("Proxy-Connection");
        ((HttpHeaders)object).remove("Transfer-Encoding");
        DefaultSpdySynStreamFrame defaultSpdySynStreamFrame = new DefaultSpdySynStreamFrame(n2, n3, by);
        SpdyHeaders spdyHeaders = defaultSpdySynStreamFrame.headers();
        spdyHeaders.set(":method", httpRequest.getMethod());
        spdyHeaders.set(":path", httpRequest.getUri());
        spdyHeaders.set(":version", httpRequest.getProtocolVersion());
        String string = ((HttpHeaders)object).get("Host");
        ((HttpHeaders)object).remove("Host");
        spdyHeaders.set(":host", string);
        if (object2 == null) {
            object2 = "https";
        }
        spdyHeaders.set(":scheme", object2);
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            spdyHeaders.add((String)object2.getKey(), object2.getValue());
        }
        this.currentStreamId = defaultSpdySynStreamFrame.streamId();
        if (n3 == 0) {
            defaultSpdySynStreamFrame.setLast(SpdyHttpEncoder.isLast(httpRequest));
        } else {
            defaultSpdySynStreamFrame.setUnidirectional(true);
        }
        return defaultSpdySynStreamFrame;
    }

    private SpdyHeadersFrame createHeadersFrame(HttpResponse httpResponse) {
        Object object = httpResponse.headers();
        int n2 = SpdyHttpHeaders.getStreamId(httpResponse);
        ((HttpHeaders)object).remove("x-spdy-stream-id");
        ((HttpHeaders)object).remove("Connection");
        ((HttpHeaders)object).remove("Keep-Alive");
        ((HttpHeaders)object).remove("Proxy-Connection");
        ((HttpHeaders)object).remove("Transfer-Encoding");
        DefaultSpdyHeadersFrame defaultSpdyHeadersFrame = SpdyCodecUtil.isServerId(n2) ? new DefaultSpdyHeadersFrame(n2) : new DefaultSpdySynReplyFrame(n2);
        Object object2 = defaultSpdyHeadersFrame.headers();
        ((SpdyHeaders)object2).set(":status", httpResponse.getStatus().code());
        ((SpdyHeaders)object2).set(":version", httpResponse.getProtocolVersion());
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            defaultSpdyHeadersFrame.headers().add((String)object2.getKey(), object2.getValue());
        }
        this.currentStreamId = n2;
        defaultSpdyHeadersFrame.setLast(SpdyHttpEncoder.isLast(httpResponse));
        return defaultSpdyHeadersFrame;
    }

    private static boolean isLast(HttpMessage httpMessage) {
        return httpMessage instanceof FullHttpMessage && (httpMessage = (FullHttpMessage)httpMessage).trailingHeaders().isEmpty() && !httpMessage.content().isReadable();
    }
}

