/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;

public final class SpdyHttpHeaders {
    private SpdyHttpHeaders() {
    }

    public static void removeStreamId(HttpMessage httpMessage) {
        httpMessage.headers().remove("x-spdy-stream-id");
    }

    public static int getStreamId(HttpMessage httpMessage) {
        return HttpHeaders.getIntHeader(httpMessage, "x-spdy-stream-id");
    }

    public static void setStreamId(HttpMessage httpMessage, int n2) {
        HttpHeaders.setIntHeader(httpMessage, "x-spdy-stream-id", n2);
    }

    public static void removeAssociatedToStreamId(HttpMessage httpMessage) {
        httpMessage.headers().remove("x-spdy-associated-to-stream-id");
    }

    public static int getAssociatedToStreamId(HttpMessage httpMessage) {
        return HttpHeaders.getIntHeader(httpMessage, "x-spdy-associated-to-stream-id", 0);
    }

    public static void setAssociatedToStreamId(HttpMessage httpMessage, int n2) {
        HttpHeaders.setIntHeader(httpMessage, "x-spdy-associated-to-stream-id", n2);
    }

    public static void removePriority(HttpMessage httpMessage) {
        httpMessage.headers().remove("x-spdy-priority");
    }

    public static byte getPriority(HttpMessage httpMessage) {
        return (byte)HttpHeaders.getIntHeader(httpMessage, "x-spdy-priority", 0);
    }

    public static void setPriority(HttpMessage httpMessage, byte by) {
        HttpHeaders.setIntHeader(httpMessage, "x-spdy-priority", (int)by);
    }

    public static void removeScheme(HttpMessage httpMessage) {
        httpMessage.headers().remove("x-spdy-scheme");
    }

    public static String getScheme(HttpMessage httpMessage) {
        return httpMessage.headers().get("x-spdy-scheme");
    }

    public static void setScheme(HttpMessage httpMessage, String string) {
        httpMessage.headers().set("x-spdy-scheme", (Object)string);
    }
}

